/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import spoon.OutputType;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.position.NoSourcePosition;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.TokenWriter;
import spoon.support.Experimental;
import spoon.support.comparator.CtLineElementComparator;
import spoon.support.modelobs.ChangeCollector;
import spoon.support.sniper.internal.ChangeResolver;
import spoon.support.sniper.internal.CollectionSourceFragment;
import spoon.support.sniper.internal.DefaultSourceFragmentPrinter;
import spoon.support.sniper.internal.ElementPrinterEvent;
import spoon.support.sniper.internal.ElementSourceFragment;
import spoon.support.sniper.internal.ModificationStatus;
import spoon.support.sniper.internal.MutableTokenWriter;
import spoon.support.sniper.internal.PrinterEvent;
import spoon.support.sniper.internal.SourceFragment;
import spoon.support.sniper.internal.SourceFragmentContextList;
import spoon.support.sniper.internal.SourceFragmentContextNormal;
import spoon.support.sniper.internal.SourceFragmentPrinter;
import spoon.support.sniper.internal.TokenPrinterEvent;
import spoon.support.sniper.internal.TokenType;
import spoon.support.sniper.internal.TokenWriterProxy;
import spoon.support.util.ModelList;

@Experimental
public class SniperJavaPrettyPrinter
extends DefaultJavaPrettyPrinter
implements TokenWriterProxy.Listener {
    private final MutableTokenWriter mutableTokenWriter;
    private ChangeResolver changeResolver;
    private final Deque<SourceFragmentPrinter> sourceFragmentContextStack = new ArrayDeque<SourceFragmentPrinter>();
    private static final String CR = "\r";
    private static final String CRLF = "\r\n";
    private static final String LF = "\n";

    public SniperJavaPrettyPrinter(Environment env) {
        super(env);
        this.inlineElseIf = false;
        env.useTabulations(true);
        env.setCommentEnabled(true);
        env.setOutputType(OutputType.COMPILATION_UNITS);
        this.mutableTokenWriter = new MutableTokenWriter(env);
        this.setPrinterTokenWriter(this.createTokenWriterListener(this.mutableTokenWriter));
        this.setIgnoreImplicit(false);
    }

    private ChangeCollector getChangeCollector() {
        ChangeCollector changeCollector = ChangeCollector.getChangeCollector(this.env);
        if (changeCollector == null) {
            throw new SpoonException(ChangeCollector.class.getSimpleName() + " was not attached to the Environment");
        }
        return changeCollector;
    }

    private ChangeResolver getChangeResolver() {
        if (this.changeResolver == null) {
            this.changeResolver = new ChangeResolver(this.getChangeCollector(), null);
        }
        return this.changeResolver;
    }

    private TokenWriter createTokenWriterListener(TokenWriter tokenWriter) {
        return new TokenWriterProxy(this, tokenWriter);
    }

    @Override
    public void calculate(CtCompilationUnit compilationUnit, List<CtType<?>> types) {
        this.sourceCompilationUnit = compilationUnit;
        this.setLineSeparator(this.detectLineSeparator(compilationUnit.getOriginalSourceCode()));
        this.runInContext(new SourceFragmentContextList(this.mutableTokenWriter, compilationUnit, Collections.singletonList(compilationUnit.getOriginalSourceFragment()), new ChangeResolver(this.getChangeCollector(), compilationUnit)), () -> super.calculate(this.sourceCompilationUnit, types));
    }

    private String detectLineSeparator(String text) {
        if (text != null) {
            int len = text.length();
            for (int i2 = 0; i2 < len; ++i2) {
                char c = text.charAt(i2);
                if (c == '\n') {
                    return LF;
                }
                if (c != '\r') continue;
                if (++i2 < len && text.charAt(i2) == '\n') {
                    return CRLF;
                }
                return CR;
            }
        }
        return System.getProperty("line.separator");
    }

    @Override
    public void onTokenWriterWrite(TokenType tokenType, String token, CtComment comment, final Runnable printAction) {
        this.executePrintEventInContext(new TokenPrinterEvent(tokenType, token, comment){

            @Override
            public void printSourceFragment(SourceFragment fragment, ModificationStatus isModified) {
                if (isModified == ModificationStatus.UNKNOWN || isModified == ModificationStatus.MODIFIED) {
                    printAction.run();
                    return;
                }
                if (fragment instanceof CollectionSourceFragment) {
                    SourceFragmentPrinter listContext = SniperJavaPrettyPrinter.this.getCollectionContext(null, (CollectionSourceFragment)fragment, isModified.toBoolean());
                    listContext.update(this);
                    SniperJavaPrettyPrinter.this.pushContext(listContext);
                }
                SniperJavaPrettyPrinter.this.mutableTokenWriter.directPrint(fragment.getSourceCode());
            }
        });
    }

    private void pushContext(SourceFragmentPrinter listContext) {
        listContext.onPush();
        this.sourceFragmentContextStack.push(listContext);
    }

    public static boolean hasImplicitAncestor(CtElement el) {
        if (el == null || !el.isParentInitialized()) {
            return false;
        }
        if (el == el.getFactory().getModel().getRootPackage()) {
            return false;
        }
        if (el.isImplicit()) {
            return true;
        }
        return SniperJavaPrettyPrinter.hasImplicitAncestor(el.getParent());
    }

    @Override
    public String printElement(CtElement element) {
        return element.toStringDebug();
    }

    public String printElementSniper(CtElement element) {
        CompilationUnit compilationUnit;
        this.reset();
        if (!SniperJavaPrettyPrinter.hasImplicitAncestor(element) && (compilationUnit = element.getPosition().getCompilationUnit()) != null && !(compilationUnit instanceof NoSourcePosition.NullCompilationUnit)) {
            this.setLineSeparator(this.detectLineSeparator(compilationUnit.getOriginalSourceCode()));
            ElementSourceFragment esf = element.getOriginalSourceFragment();
            this.runInContext(new SourceFragmentContextList(this.mutableTokenWriter, element, Collections.singletonList(esf), new ChangeResolver(this.getChangeCollector(), element)), () -> this.executePrintEventInContext(this.createPrinterEvent(element)));
        }
        return this.toString().replaceFirst("^\\s+", "");
    }

    @Override
    public SniperJavaPrettyPrinter scan(CtElement element) {
        if (element != null) {
            this.executePrintEventInContext(this.createPrinterEvent(element));
        }
        return this;
    }

    private PrinterEvent createPrinterEvent(CtElement element) {
        CtRole role = this.getRoleInCompilationUnit(element);
        return new ElementPrinterEvent(role, element){

            @Override
            public void printSourceFragment(SourceFragment fragment, ModificationStatus isModified) {
                if (fragment == null) {
                    SniperJavaPrettyPrinter.this.superScanInContext(this.element, DefaultSourceFragmentPrinter.INSTANCE);
                    return;
                }
                if (fragment instanceof CollectionSourceFragment) {
                    SourceFragmentPrinter listContext = SniperJavaPrettyPrinter.this.getCollectionContext(this.element, (CollectionSourceFragment)fragment, isModified.toBoolean());
                    SniperJavaPrettyPrinter.this.pushContext(listContext);
                    if (ModificationStatus.NOT_MODIFIED.equals((Object)isModified)) {
                        SniperJavaPrettyPrinter.this.mutableTokenWriter.directPrint(fragment.getSourceCode());
                    } else {
                        listContext.print(this);
                    }
                } else if (fragment instanceof ElementSourceFragment) {
                    ElementSourceFragment sourceFragment = (ElementSourceFragment)fragment;
                    if (isModified == ModificationStatus.NOT_MODIFIED) {
                        SniperJavaPrettyPrinter.this.mutableTokenWriter.directPrint(fragment.getSourceCode());
                        return;
                    }
                    SniperJavaPrettyPrinter.this.superScanInContext(this.element, new SourceFragmentContextNormal(SniperJavaPrettyPrinter.this.mutableTokenWriter, sourceFragment, new ChangeResolver(SniperJavaPrettyPrinter.this.getChangeCollector(), this.element)));
                } else {
                    throw new SpoonException("Unsupported fragment type: " + fragment.getClass());
                }
            }
        };
    }

    private CtRole getRoleInCompilationUnit(CtElement element) {
        CtRole role = element.getRoleInParent();
        if (role == CtRole.CONTAINED_TYPE) {
            role = CtRole.DECLARED_TYPE;
        }
        return role;
    }

    private void executePrintEventInContext(PrinterEvent event) {
        SourceFragmentPrinter sfc = this.detectCurrentContext(event);
        if (sfc == null) {
            throw new SpoonException("Missing SourceFragmentContext");
        }
        sfc.print(event);
    }

    private SourceFragmentPrinter detectCurrentContext(PrinterEvent event) {
        SourceFragmentPrinter sfc;
        while ((sfc = this.sourceFragmentContextStack.peek()) != null && !sfc.knowsHowToPrint(event)) {
            sfc = this.popSourceFragmentContext();
        }
        return sfc;
    }

    private SourceFragmentPrinter getCollectionContext(CtElement element, CollectionSourceFragment csf, final boolean isModified) {
        return new SourceFragmentContextList(this.mutableTokenWriter, element, csf.getItems(), this.getChangeResolver()){

            @Override
            public void onPush() {
                super.onPush();
                if (!isModified) {
                    this.mutableTokenWriter.setMuted(true);
                }
            }

            @Override
            public void onFinished() {
                super.onFinished();
                if (!isModified) {
                    this.mutableTokenWriter.setMuted(false);
                }
            }
        };
    }

    private void superScanInContext(CtElement element, SourceFragmentPrinter context) {
        this.runInContext(context, () -> super.scan(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInContext(SourceFragmentPrinter context, Runnable code) {
        this.pushContext(context);
        try {
            code.run();
        }
        finally {
            SourceFragmentPrinter c;
            do {
                if (!this.sourceFragmentContextStack.isEmpty()) continue;
                throw new SpoonException("Inconsistent sourceFragmentContextStack");
            } while ((c = this.popSourceFragmentContext()) != context);
        }
    }

    private SourceFragmentPrinter popSourceFragmentContext() {
        SourceFragmentPrinter c = this.sourceFragmentContextStack.pop();
        c.onFinished();
        return c;
    }

    @Override
    protected ModelList<CtImport> getImports(CtCompilationUnit compilationUnit) {
        ModelList<CtImport> imports = super.getImports(compilationUnit);
        imports.sort(new CtLineElementComparator());
        return imports;
    }
}

