/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import spoon.SpoonException;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.SourcePositionHolder;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.path.CtRole;
import spoon.support.sniper.internal.ChangeResolver;
import spoon.support.sniper.internal.CollectionSourceFragment;
import spoon.support.sniper.internal.ElementSourceFragment;
import spoon.support.sniper.internal.ModificationStatus;
import spoon.support.sniper.internal.MutableTokenWriter;
import spoon.support.sniper.internal.PrinterEvent;
import spoon.support.sniper.internal.SourceFragment;
import spoon.support.sniper.internal.SourceFragmentPrinter;
import spoon.support.sniper.internal.TokenPrinterEvent;
import spoon.support.sniper.internal.TokenSourceFragment;
import spoon.support.sniper.internal.TokenType;

abstract class AbstractSourceFragmentPrinter
implements SourceFragmentPrinter {
    protected final MutableTokenWriter mutableTokenWriter;
    protected final List<SourceFragment> childFragments;
    protected final ChangeResolver changeResolver;
    protected int childFragmentIdx = -1;
    protected final List<Runnable> separatorActions = new ArrayList<Runnable>();

    protected AbstractSourceFragmentPrinter(MutableTokenWriter mutableTokenWriter, ChangeResolver changeResolver, List<SourceFragment> childFragments) {
        this.mutableTokenWriter = mutableTokenWriter;
        this.changeResolver = changeResolver;
        this.childFragments = childFragments;
    }

    @Override
    public void print(PrinterEvent event) {
        if (this.mutableTokenWriter.isMuted()) {
            return;
        }
        int prevIndex = this.childFragmentIdx;
        int index = this.update(event);
        if (index != -1) {
            this.printSpaces(this.getLastNonSpaceNonCommentBefore(index), index);
            SourceFragment fragment = this.childFragments.get(index);
            event.printSourceFragment(fragment, this.isFragmentModified(fragment));
        }
    }

    @Override
    public int update(PrinterEvent event) {
        int fragmentIndex;
        if (event instanceof TokenPrinterEvent) {
            TokenPrinterEvent tpe = (TokenPrinterEvent)event;
            if (tpe.getType().isTab()) {
                event.printSourceFragment(null, ModificationStatus.UNKNOWN);
                return -1;
            }
            if (tpe.getType().isWhiteSpace()) {
                this.separatorActions.add(() -> event.printSourceFragment(null, ModificationStatus.UNKNOWN));
                return -1;
            }
        }
        if ((fragmentIndex = this.findIFragmentIndexCorrespondingToEvent(event)) < 0) {
            this.printSpaces(this.childFragmentIdx, -1);
            event.printSourceFragment(null, ModificationStatus.UNKNOWN);
            return -1;
        }
        if (event.getRole() == CtRole.COMMENT) {
            return -1;
        }
        this.setChildFragmentIdx(fragmentIndex);
        return fragmentIndex;
    }

    @Override
    public void onFinished() {
    }

    protected void printSpaces(int fromIndex, int fragmentIndex) {
        if (fragmentIndex < 0) {
            this.printStandardSpaces();
        } else {
            this.printOriginSpacesUntilFragmentIndex(fromIndex, fragmentIndex);
        }
    }

    protected ModificationStatus isFragmentModified(SourceFragment fragment) {
        if (fragment instanceof TokenSourceFragment) {
            switch (((TokenSourceFragment)fragment).getType()) {
                case IDENTIFIER: {
                    return ModificationStatus.UNKNOWN;
                }
                case COMMENT: {
                    return ModificationStatus.UNKNOWN;
                }
            }
            return ModificationStatus.NOT_MODIFIED;
        }
        if (fragment instanceof ElementSourceFragment) {
            return ModificationStatus.fromBoolean(this.changeResolver.isRoleModified(((ElementSourceFragment)fragment).getRoleInParent()));
        }
        if (fragment instanceof CollectionSourceFragment) {
            CollectionSourceFragment csf = (CollectionSourceFragment)fragment;
            for (SourceFragment sourceFragment : csf.getItems()) {
                ModificationStatus modified = this.isFragmentModified(sourceFragment);
                if (ModificationStatus.NOT_MODIFIED.equals((Object)modified)) continue;
                return modified;
            }
            return ModificationStatus.NOT_MODIFIED;
        }
        throw new SpoonException("Unexpected SourceFragment type " + fragment.getClass());
    }

    protected void printOriginSpacesUntilFragmentIndex(int fromIndex, int toIndex) {
        boolean canPrintSpace = true;
        boolean skipSpaceAfterDeletedElement = false;
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            SourceFragment fragment = this.childFragments.get(i2);
            if (fragment instanceof ElementSourceFragment) {
                ElementSourceFragment sourceFragment = (ElementSourceFragment)fragment;
                if (!(sourceFragment.getElement() instanceof CtComment)) continue;
                CtComment comment = (CtComment)sourceFragment.getElement();
                if (this.changeResolver.isElementExists(comment)) {
                    if (this.changeResolver.getChanges(comment).size() > 0) {
                        this.mutableTokenWriter.writeComment(comment);
                    } else {
                        this.mutableTokenWriter.write(fragment.getSourceCode());
                    }
                    canPrintSpace = true;
                    continue;
                }
                canPrintSpace = false;
                continue;
            }
            if (ElementSourceFragment.isSpaceFragment(fragment) && canPrintSpace) {
                if (!skipSpaceAfterDeletedElement) {
                    this.mutableTokenWriter.write(fragment.getSourceCode());
                } else {
                    skipSpaceAfterDeletedElement = false;
                }
                canPrintSpace = false;
                continue;
            }
            skipSpaceAfterDeletedElement = true;
        }
        this.separatorActions.clear();
    }

    protected void setChildFragmentIdx(int idx) {
        this.childFragmentIdx = idx;
    }

    protected boolean hasNextChildToken() {
        return this.childFragmentIdx + 1 < this.childFragments.size();
    }

    protected int findIndexOfNextChildTokenByValue(String token) {
        return ElementSourceFragment.findIndexOfNextFragment(this.childFragments, this.childFragmentIdx + 1, fragment -> Objects.equals(token, fragment.getSourceCode()));
    }

    protected int findIndexOfNextChildTokenByType(TokenType type) {
        return ElementSourceFragment.findIndexOfNextFragment(this.childFragments, this.childFragmentIdx + 1, ElementSourceFragment.filter(TokenSourceFragment.class, fragment -> type == fragment.getType()));
    }

    protected int findIndexOfNextChildTokenOfRole(int start, CtRole role) {
        return ElementSourceFragment.findIndexOfNextFragment(this.childFragments, start, ElementSourceFragment.checkCollectionItems(ElementSourceFragment.filter(ElementSourceFragment.class, elementFragment -> elementFragment.getRoleInParent() == role)));
    }

    protected int findIndexOfNextChildTokenOfElement(SourcePositionHolder element) {
        return ElementSourceFragment.findIndexOfNextFragment(this.childFragments, this.childFragmentIdx + 1, ElementSourceFragment.checkCollectionItems(ElementSourceFragment.filter(ElementSourceFragment.class, elementFragment -> elementFragment.getElement() == element)));
    }

    protected int findIFragmentIndexCorrespondingToEvent(PrinterEvent event) {
        CtRole role = event.getRole();
        if (role != null) {
            if (event.getElement() instanceof CtModifiable || role == CtRole.MODIFIER) {
                return this.findIndexOfNextChildTokenOfRole(this.childFragmentIdx + 1, role);
            }
            return this.findIndexOfNextChildTokenOfElement(event.getElement());
        }
        if (event instanceof TokenPrinterEvent) {
            TokenPrinterEvent tpe = (TokenPrinterEvent)event;
            if (tpe.getType() == TokenType.IDENTIFIER) {
                return this.findIndexOfNextChildTokenByType(TokenType.IDENTIFIER);
            }
            return this.findIndexOfNextChildTokenByValue(tpe.getToken());
        }
        return -1;
    }

    protected void printStandardSpaces() {
        for (Runnable runnable : this.separatorActions) {
            runnable.run();
        }
        this.separatorActions.clear();
    }

    private int getLastNonSpaceNonCommentBefore(int index) {
        for (int i2 = index - 1; i2 >= 0; --i2) {
            SourceFragment fragment = this.childFragments.get(i2);
            if (ElementSourceFragment.isSpaceFragment(fragment) || ElementSourceFragment.isCommentFragment(fragment)) continue;
            return i2 + 1;
        }
        return 0;
    }

    @Override
    public void onPush() {
    }
}

