/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.sniper.internal;

import java.util.Collections;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.cu.SourcePositionHolder;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.path.CtRole;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.support.modelobs.ChangeCollector;
import spoon.support.reflect.CtExtendedModifier;

public class ChangeResolver {
    private final ChangeCollector changeCollector;
    private final CtElement element;
    private final Set<CtRole> changedRoles;

    public ChangeResolver(ChangeCollector changeCollector, CtElement element) {
        this.changeCollector = changeCollector;
        this.element = element;
        this.changedRoles = element != null ? changeCollector.getChanges(element) : Collections.EMPTY_SET;
    }

    public boolean isElementExists(final SourcePositionHolder element) {
        if (element instanceof CtExtendedModifier) {
            CtExtendedModifier modifier = (CtExtendedModifier)element;
            if (this.element instanceof CtModifiable) {
                return ((CtModifiable)this.element).hasModifier(modifier.getKind());
            }
        }
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            @Override
            protected void enter(CtElement e) {
                if (element == e) {
                    this.setResult(Boolean.TRUE);
                    this.terminate();
                }
            }
        };
        scanner.scan(this.element);
        return Boolean.TRUE.equals(scanner.getResult());
    }

    public Set<CtRole> getChanges(SourcePositionHolder element) {
        if (element instanceof CtElement) {
            return this.changeCollector.getChanges((CtElement)element);
        }
        return Collections.emptySet();
    }

    public boolean isRoleModified(CtRole ctRole) {
        if (this.changedRoles == null) {
            throw new SpoonException("changedRoles are not initialized for this ChangeResolver. Use getChanges(...) instead");
        }
        return this.changedRoles.contains((Object)ctRole);
    }

    public boolean hasChangedRole() {
        return this.changedRoles.size() > 0;
    }

    public ChangeCollector getChangeCollector() {
        return this.changeCollector;
    }
}

