/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import spoon.SpoonException;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.support.modelobs.FineModelChangeListener;
import spoon.support.reflect.declaration.CtElementImpl;

public abstract class ModelList<T extends CtElement>
extends AbstractList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> list = CtElementImpl.emptyList();

    protected ModelList() {
    }

    protected abstract CtElement getOwner();

    protected abstract CtRole getRole();

    protected abstract int getDefaultCapacity();

    protected void onSizeChanged(int newSize) {
    }

    @Override
    public T get(int index) {
        return (T)((CtElement)this.list.get(index));
    }

    public void set(Collection<T> elements) {
        this.clear();
        if (elements != null && !elements.isEmpty()) {
            this.addAll(elements);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public T set(int index, T element) {
        CtElement oldElement = (CtElement)this.list.get(index);
        if (oldElement == element) {
            return (T)oldElement;
        }
        CtElement owner = this.getOwner();
        this.ensureModifiableList();
        this.getModelChangeListener().onListDelete(owner, this.getRole(), this.list, index, oldElement);
        ModelList.linkToParent(owner, element);
        this.getModelChangeListener().onListAdd(owner, this.getRole(), this.list, index, (CtElement)element);
        this.list.set(index, element);
        this.updateModCount();
        return (T)oldElement;
    }

    static void linkToParent(CtElement owner, CtElement element) {
        if (!owner.getFactory().getEnvironment().checksAreSkipped() && element.isParentInitialized() && element.getParent() != owner && element.getRoleInParent() != null) {
            throw new SpoonException("The default behavior has changed, a new check has been added! Don't worry, you can disable this check\nwith one of the following options:\n - by configuring Spoon with getEnvironment().setSelfChecks(true)\n - by removing the node from its previous parent (element.delete())\n - by cloning the node before adding it here (element.clone())\n");
        }
        element.setParent(owner);
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        if (e == null) {
            return false;
        }
        CtElement owner = this.getOwner();
        this.ensureModifiableList();
        ModelList.linkToParent(owner, e);
        this.getModelChangeListener().onListAdd(owner, this.getRole(), this.list, (CtElement)e);
        boolean result = this.list.add(e);
        this.updateModCount();
        this.onSizeChanged(this.list.size());
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (this.list.isEmpty()) {
            return false;
        }
        int size = this.list.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.list.get(i2) != o) continue;
            this.remove(i2);
            return true;
        }
        int idx = this.list.indexOf(o);
        if (idx >= 0) {
            this.remove(idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public void clear() {
        this.getModelChangeListener().onListDeleteAll(this.getOwner(), this.getRole(), this.list, new ArrayList<T>(this.list));
        this.list = CtElementImpl.emptyList();
        ++this.modCount;
        this.onSizeChanged(this.list.size());
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void add(int index, T element) {
        if (element == null) {
            return;
        }
        CtElement owner = this.getOwner();
        this.ensureModifiableList();
        ModelList.linkToParent(owner, element);
        this.getModelChangeListener().onListAdd(owner, this.getRole(), this.list, index, (CtElement)element);
        this.list.add(index, element);
        this.updateModCount();
        this.onSizeChanged(this.list.size());
    }

    @Override
    public T remove(int index) {
        CtElement oldElement = (CtElement)this.list.get(index);
        this.getModelChangeListener().onListDelete(this.getOwner(), this.getRole(), this.list, index, oldElement);
        this.list.remove(index);
        this.updateModCount();
        this.onSizeChanged(this.list.size());
        return (T)oldElement;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    protected void updateModCount() {
        if (this.list instanceof InternalList) {
            this.modCount = ((InternalList)this.list).getModCount();
        }
    }

    private void ensureModifiableList() {
        if (this.list == CtElementImpl.emptyList()) {
            this.list = new InternalList(this.getDefaultCapacity());
        }
    }

    private FineModelChangeListener getModelChangeListener() {
        return this.getOwner().getFactory().getEnvironment().getModelChangeListener();
    }

    private static class InternalList<T>
    extends ArrayList<T> {
        InternalList(int initialCapacity) {
            super(initialCapacity);
        }

        int getModCount() {
            return this.modCount;
        }
    }
}

