/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtScanner;

public class SignaturePrinter
extends CtScanner {
    private final StringBuilder signature = new StringBuilder();

    public String getSignature() {
        return this.signature.toString();
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.scan(reference.getComponentType());
        this.write("[]");
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.writeNameAndParameters(reference);
    }

    public <T> void writeNameAndParameters(CtExecutableReference<T> reference) {
        if (reference.isConstructor()) {
            this.write(reference.getDeclaringType().getQualifiedName());
        } else {
            this.write(reference.getSimpleName());
        }
        this.write("(");
        if (!reference.getParameters().isEmpty()) {
            for (CtTypeReference<?> param : reference.getParameters()) {
                if (param != null && !"null".equals(param.getSimpleName())) {
                    this.scan(param);
                } else {
                    this.write("<unknown>");
                }
                this.write(",");
            }
            if (!reference.getParameters().isEmpty()) {
                this.clearLast();
            }
        }
        this.write(")");
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.write(reference.getQualifiedName());
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.scan(ref.getBoundingType());
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference ref) {
        this.write(ref.getSimpleName());
        if (!ref.isDefaultBoundingType() || !ref.getBoundingType().isImplicit()) {
            if (ref.isUpper()) {
                this.write(" extends ");
            } else {
                this.write(" super ");
            }
            this.scan(ref.getBoundingType());
        }
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        for (CtTypeReference<?> bound : reference.getBounds()) {
            this.scan(bound);
            this.write(",");
        }
        this.clearLast();
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        if (c.getDeclaringType() != null) {
            this.write(c.getDeclaringType().getQualifiedName());
        }
        this.write("(");
        for (CtParameter<?> p : c.getParameters()) {
            this.scan(p.getType());
            this.write(",");
        }
        if (!c.getParameters().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.visitCtMethod(annotationMethod);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.write(m.getSimpleName());
        this.write("(");
        for (CtParameter<?> p : m.getParameters()) {
            this.scan(p.getType());
            this.write(",");
        }
        if (!m.getParameters().isEmpty()) {
            this.clearLast();
        }
        this.write(")");
    }

    private SignaturePrinter clearLast() {
        this.signature.deleteCharAt(this.signature.length() - 1);
        return this;
    }

    protected SignaturePrinter write(String value) {
        this.signature.append(value);
        return this;
    }
}

