/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class TypeReferenceScanner
extends CtScanner {
    Set<CtTypeReference<?>> references;

    public TypeReferenceScanner() {
        this.references = new HashSet();
    }

    public TypeReferenceScanner(HashSet<CtTypeReference<?>> references) {
        this.references = references;
    }

    public Set<CtTypeReference<?>> getReferences() {
        return this.references;
    }

    private <T> boolean addReference(CtTypeReference<T> ref) {
        return this.references.add(ref);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        super.visitCtFieldRead(fieldRead);
        this.enter(fieldRead);
        this.scan(fieldRead.getVariable());
        this.scan(fieldRead.getAnnotations());
        this.scan(fieldRead.getTypeCasts());
        this.scan(fieldRead.getVariable());
        this.scan((CtElement)fieldRead.getTarget());
        this.exit(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.enter(fieldWrite);
        this.scan(fieldWrite.getVariable());
        this.scan(fieldWrite.getAnnotations());
        this.scan(fieldWrite.getTypeCasts());
        this.scan(fieldWrite.getVariable());
        this.scan((CtElement)fieldWrite.getTarget());
        this.exit(fieldWrite);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getDeclaringType());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getDeclaringType());
        this.scan(reference.getActualTypeArguments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        if (!(reference instanceof CtArrayTypeReference)) {
            this.addReference(reference);
        }
        super.visitCtTypeReference(reference);
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.addReference((CtTypeReference)annotationType.getReference());
        super.visitCtAnnotationType(annotationType);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.addReference((CtTypeReference<T>)ctEnum.getReference());
        super.visitCtEnum(ctEnum);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.addReference((CtTypeReference<T>)intrface.getReference());
        for (CtTypeMember typeMember : intrface.getTypeMembers()) {
            if (!(typeMember instanceof CtType)) continue;
            this.addReference((CtTypeReference<T>)((CtType)typeMember).getReference());
        }
        super.visitCtInterface(intrface);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.addReference((CtTypeReference<T>)ctClass.getReference());
        for (CtTypeMember typeMember : ctClass.getTypeMembers()) {
            if (!(typeMember instanceof CtType)) continue;
            this.addReference((CtTypeReference<T>)((CtType)typeMember).getReference());
        }
        super.visitCtClass(ctClass);
    }
}

