/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing;

import java.io.File;
import java.util.List;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.testing.AbstractAssert;
import spoon.testing.utils.Check;
import spoon.testing.utils.ModelUtils;
import spoon.testing.utils.ProcessorUtils;

public abstract class AbstractFileAssert<T extends AbstractFileAssert<T>>
extends AbstractAssert<T, File> {
    public AbstractFileAssert(File actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public T isEqualTo(String expected) {
        return this.isEqualTo(new File(expected));
    }

    public T isEqualTo(File expected) {
        Check.assertNotNull(expected);
        Check.assertExists(expected);
        Factory actualFactory = ModelUtils.build((File)this.actual);
        Factory expectedFactory = ModelUtils.build(expected);
        ProcessorUtils.process(actualFactory, this.processors);
        List<CtType<?>> allActual = actualFactory.Type().getAll();
        List<CtType<?>> allExpected = expectedFactory.Type().getAll();
        for (int i2 = 0; i2 < allActual.size(); ++i2) {
            CtType<?> currentExpected;
            CtType<?> currentActual = allActual.get(i2);
            if (!currentActual.equals(currentExpected = allExpected.get(i2))) {
                throw new AssertionError((Object)String.format("%1$s and %2$s aren't equals.", currentActual.getQualifiedName(), currentExpected.getQualifiedName()));
            }
        }
        return (T)((AbstractFileAssert)this.myself);
    }
}

