/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes;

import eu.stamp_project.mutationtest.descartes.DescartesMutationEngine;
import eu.stamp_project.mutationtest.descartes.bodyanalysis.MethodInspector;
import eu.stamp_project.mutationtest.descartes.operators.MutationOperator;
import eu.stamp_project.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.commons.Method;

public class MutationPointFinder
extends ClassVisitor {
    private final ClassName className;
    private String source = null;
    private final DescartesMutationEngine engine;
    private List<MutationDetails> mutationPoints;

    public MutationPointFinder(ClassName className, DescartesMutationEngine engine) {
        super(327680);
        this.engine = engine;
        this.className = className;
        this.mutationPoints = new ArrayList<MutationDetails>();
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.source = source;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (Utils.hasFlag(access, 1280) || Utils.isConstructor(name)) {
            return null;
        }
        Method method = new Method(name, desc);
        if (this.engine.getOperatorsFor(method).isEmpty()) {
            return null;
        }
        return new MethodInspector(method, this);
    }

    public void registerMutations(Method method, int start, int end) {
        for (MutationOperator operator : this.engine.getOperatorsFor(method)) {
            this.mutationPoints.add(this.getMutationDetails(method, operator, start, end));
        }
    }

    private MutationDetails getMutationDetails(Method method, MutationOperator operator, int start, int end) {
        Location location = new Location(this.className, MethodName.fromString(method.getName()), method.getDescriptor());
        MutationIdentifier id = new MutationIdentifier(location, this.getIndexes(start, end), operator.getID());
        return new MutationDetails(id, this.source, operator.getDescription(), start, 1);
    }

    private Collection<Integer> getIndexes(int start, int end) {
        return IntStream.rangeClosed(1, end - start + 1).boxed().collect(Collectors.toList());
    }

    public List<MutationDetails> getMutationPoints() {
        return this.mutationPoints;
    }
}

