/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.operators.parsing;

import eu.stamp_project.mutationtest.descartes.operators.parsing.OperatorLexer;
import eu.stamp_project.mutationtest.descartes.operators.parsing.Token;
import eu.stamp_project.mutationtest.descartes.operators.parsing.TokenType;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class OperatorParser {
    private final OperatorLexer lexer;
    private Token lookahead;
    private Object result;
    private final List<String> errors;

    public OperatorParser(String input) {
        this.lexer = new OperatorLexer(new StringReader(input));
        this.errors = new LinkedList<String>();
    }

    public Object getResult() {
        return this.result;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    private boolean match(TokenType token) throws IOException {
        if (this.lookahead.getType() == token) {
            try {
                this.next();
                return true;
            }
            catch (Throwable throwable) {
                this.errors.add(throwable.getMessage());
                return false;
            }
        }
        return false;
    }

    private void next() throws Throwable {
        this.lookahead = this.lexer.nextToken();
    }

    private boolean lookaheadIs(TokenType token) {
        return this.lookahead.getType() == token;
    }

    private boolean lookaheadIsOneOf(TokenType ... tokens) {
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            if (!this.lookaheadIs(tokens[i2])) continue;
            return true;
        }
        return false;
    }

    public Object parse() {
        this.result = null;
        try {
            this.next();
            if (this.lookaheadIsOneOf(TokenType.NULL_KWD, TokenType.VOID_KWD, TokenType.TRUE_KWD, TokenType.FALSE_KWD, TokenType.EMPTY_KWD, TokenType.CHAR_LITERAL, TokenType.STRING_LITERAL, TokenType.INT_LITERAL, TokenType.LONG_LITERAL, TokenType.FLOAT_LITERAL, TokenType.DOUBLE_LITERAL)) {
                this.result = this.lookahead.getData();
            } else if (this.lookaheadIs(TokenType.MINUS)) {
                this.parseNegatedNumber();
            } else if (this.lookaheadIs(TokenType.LPAR)) {
                this.parseCastedInteger();
            } else {
                this.unexpectedTokenError();
            }
            this.next();
            if (!this.match(TokenType.EOF)) {
                this.unexpectedTokenError();
            }
            this.lexer.yyclose();
        }
        catch (Throwable exc) {
            this.errors.add("Unexpected error: " + exc.getMessage());
            this.result = null;
        }
        return this.result;
    }

    private void unexpectedTokenError() {
        this.errors.add("Unexpected token type: " + this.lookahead.getType().name());
        this.result = null;
    }

    private void parseNegatedNumber() throws IOException {
        if (this.match(TokenType.MINUS)) {
            if (this.lookaheadIs(TokenType.INT_LITERAL)) {
                this.result = -((Integer)this.lookahead.getData()).intValue();
            } else if (this.lookaheadIs(TokenType.LONG_LITERAL)) {
                this.result = -((Long)this.lookahead.getData()).longValue();
            } else if (this.lookaheadIs(TokenType.FLOAT_LITERAL)) {
                this.result = Float.valueOf(-((Float)this.lookahead.getData()).floatValue());
            } else if (this.lookaheadIs(TokenType.DOUBLE_LITERAL)) {
                this.result = -((Double)this.lookahead.getData()).doubleValue();
            } else {
                this.unexpectedTokenError();
            }
        } else {
            this.unexpectedTokenError();
        }
    }

    private void parseCastedInteger() throws Throwable {
        if (this.match(TokenType.LPAR)) {
            if (this.lookaheadIs(TokenType.BYTE_KWD)) {
                this.next();
                if (this.match(TokenType.RPAR)) {
                    boolean negate = false;
                    negate = this.lookaheadIs(TokenType.MINUS);
                    if (negate) {
                        this.next();
                    }
                    if (this.lookaheadIs(TokenType.INT_LITERAL)) {
                        this.result = ((Integer)this.lookahead.getData()).byteValue();
                        if (negate) {
                            this.result = -((Byte)this.result).byteValue();
                        }
                    } else {
                        this.unexpectedTokenError();
                    }
                } else {
                    this.unexpectedTokenError();
                }
            } else if (this.lookaheadIs(TokenType.SHORT_KWD)) {
                this.next();
                if (this.match(TokenType.RPAR)) {
                    boolean negate = false;
                    negate = this.lookaheadIs(TokenType.MINUS);
                    if (negate) {
                        this.next();
                    }
                    if (this.lookaheadIs(TokenType.INT_LITERAL)) {
                        this.result = ((Integer)this.lookahead.getData()).shortValue();
                        if (negate) {
                            this.result = -((Short)this.result).shortValue();
                        }
                    } else {
                        this.unexpectedTokenError();
                    }
                } else {
                    this.unexpectedTokenError();
                }
            } else {
                this.unexpectedTokenError();
            }
        } else {
            this.unexpectedTokenError();
        }
    }
}

