/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.reloc.tags;

import eu.stamp_project.reloc.Config;
import eu.stamp_project.reloc.TagCreator;
import eu.stamp_project.reloc.tags.ContainerTag;
import eu.stamp_project.reloc.tags.DomContent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Scanner;

public class InlineStaticResource {
    public static ContainerTag get(String path, TargetFormat format) {
        String fileString = InlineStaticResource.getFileAsString(path);
        switch (format) {
            case CSS_MIN: {
                return TagCreator.style().with((DomContent)TagCreator.rawHtml(Config.cssMinifier.minify(fileString)));
            }
            case JS_MIN: {
                return TagCreator.script().with((DomContent)TagCreator.rawHtml(Config.jsMinifier.minify(fileString)));
            }
            case CSS: {
                return TagCreator.style().with((DomContent)TagCreator.rawHtml(fileString));
            }
            case JS: {
                return TagCreator.script().with((DomContent)TagCreator.rawHtml(fileString));
            }
        }
        throw new RuntimeException("Invalid target format");
    }

    public static String getFileAsString(String path) {
        try {
            return InlineStaticResource.streamToString(InlineStaticResource.class.getResourceAsStream(path));
        }
        catch (Exception expected) {
            try {
                return InlineStaticResource.streamToString(new FileInputStream(path));
            }
            catch (Exception exception) {
                throw new RuntimeException("Couldn't find file with path='" + path + "'");
            }
        }
    }

    private static String streamToString(InputStream inputStream) {
        Scanner s = new Scanner(inputStream).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static enum TargetFormat {
        CSS_MIN,
        CSS,
        JS_MIN,
        JS;

    }
}

