/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.reloc.utils;

import eu.stamp_project.reloc.utils.EmptySelectorBodyException;
import eu.stamp_project.reloc.utils.Selector;
import eu.stamp_project.reloc.utils.UnbalancedBracesException;
import eu.stamp_project.reloc.utils.UnterminatedCommentException;
import eu.stamp_project.reloc.utils.UnterminatedSelectorException;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;
import java.util.logging.Logger;

public class CSSMin {
    private static final Logger LOG = Logger.getLogger(CSSMin.class.getName());
    static boolean debugLogging = false;

    private CSSMin() {
    }

    public static String compressCss(String input) {
        try {
            String s;
            BufferedReader br = new BufferedReader(new StringReader(input));
            StringBuilder sb = new StringBuilder();
            if (debugLogging) {
                LOG.info("Reading file into StringBuffer...");
            }
            while ((s = br.readLine()) != null) {
                if (s.trim().equals("")) continue;
                sb.append(s);
            }
            if (debugLogging) {
                LOG.info("Removing comments...");
            }
            int n = 0;
            while ((n = sb.indexOf("/*", n)) != -1) {
                if (sb.charAt(n + 2) == '*') {
                    n += 2;
                    continue;
                }
                int k = sb.indexOf("*/", n + 2);
                if (k == -1) {
                    throw new UnterminatedCommentException();
                }
                sb.delete(n, k + 2);
            }
            if (debugLogging) {
                LOG.info(sb.toString());
                LOG.info("\n\n");
            }
            if (debugLogging) {
                LOG.info("Parsing and processing selectors...");
            }
            Vector<Selector> selectors = new Vector<Selector>();
            n = 0;
            int j = 0;
            for (int i2 = 0; i2 < sb.length(); ++i2) {
                block20: {
                    char curr = sb.charAt(i2);
                    if (j < 0) {
                        throw new UnbalancedBracesException();
                    }
                    if (curr == '{') {
                        ++j;
                        continue;
                    }
                    if (curr != '}' || --j != 0) continue;
                    try {
                        selectors.addElement(new Selector(sb.substring(n, i2 + 1)));
                    }
                    catch (UnterminatedSelectorException usex) {
                        LOG.warning("Unterminated selector: " + usex.getMessage());
                    }
                    catch (EmptySelectorBodyException ebex) {
                        if (!debugLogging) break block20;
                        LOG.warning("Empty selector body: " + ebex.getMessage());
                    }
                }
                n = i2 + 1;
            }
            StringBuilder result = new StringBuilder();
            for (Selector selector : selectors) {
                result.append(selector);
            }
            if (debugLogging) {
                LOG.info("Process completed successfully.");
            }
            return result.toString();
        }
        catch (UnterminatedCommentException ucex) {
            LOG.warning("Unterminated comment.");
        }
        catch (UnbalancedBracesException ubex) {
            LOG.warning("Unbalanced braces.");
        }
        catch (Exception ex) {
            LOG.warning(ex.getMessage());
        }
        return null;
    }
}

