/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.reloc.utils;

import eu.stamp_project.reloc.utils.Constants;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Part {
    private String contents;
    private String property;

    Part(String contents, String property) throws Exception {
        this.contents = " " + contents;
        this.property = property;
        this.simplify();
    }

    private void simplify() {
        this.contents = this.contents.replaceAll(" !important", "!important");
        this.contents = this.contents.replaceAll("(\\s)(0)(px|em|%|in|cm|mm|pc|pt|ex)", "$1$2");
        this.contents = this.contents.trim();
        if (this.contents.equals("0 0 0 0")) {
            this.contents = "0";
        }
        if (this.contents.equals("0 0 0")) {
            this.contents = "0";
        }
        if (this.contents.equals("0 0")) {
            this.contents = "0";
        }
        this.simplifyParameters();
        this.simplifyFontWeights();
        this.simplifyQuotesAndCaps();
        this.simplifyColourNames();
        this.simplifyHexColours();
    }

    private void simplifyParameters() {
        if (this.property.equals("background-size")) {
            return;
        }
        StringBuilder newContents = new StringBuilder();
        String[] params = this.contents.split(" ");
        if (params.length == 4 && params[1].equalsIgnoreCase(params[3])) {
            params = Arrays.copyOf(params, 3);
        }
        if (params.length == 3 && params[0].equalsIgnoreCase(params[2])) {
            params = Arrays.copyOf(params, 2);
        }
        if (params.length == 2 && params[0].equalsIgnoreCase(params[1])) {
            params = Arrays.copyOf(params, 1);
        }
        for (String param : params) {
            newContents.append(param).append(" ");
        }
        newContents.deleteCharAt(newContents.length() - 1);
        this.contents = newContents.toString();
    }

    private void simplifyFontWeights() {
        if (!this.property.equals("font-weight")) {
            return;
        }
        String lcContents = this.contents.toLowerCase();
        for (int i2 = 0; i2 < Constants.fontWeightNames.length; ++i2) {
            if (!lcContents.equals(Constants.fontWeightNames[i2])) continue;
            this.contents = Constants.fontWeightValues[i2];
            break;
        }
    }

    private void simplifyQuotesAndCaps() {
        if (this.contents.length() > 4 && this.contents.substring(0, 4).equalsIgnoreCase("url(")) {
            this.contents = this.contents.replaceAll("(?i)url\\(('|\")?(.*?)\\1\\)", "url($2)");
        } else if (this.contents.length() > 4 && this.contents.substring(0, 4).equalsIgnoreCase("var(")) {
            this.contents = this.contents.replaceAll("\\s", "");
        } else {
            String[] words = this.contents.split("\\s");
            if (words.length == 1) {
                if (!this.property.equalsIgnoreCase("animation-name")) {
                    this.contents = this.contents.toLowerCase();
                }
                this.contents = this.contents.replaceAll("('|\")?(.*?)\u0001", "$2");
            }
        }
    }

    private void simplifyColourNames() {
        String lcContents = this.contents.toLowerCase();
        for (int i2 = 0; i2 < Constants.htmlColourNames.length; ++i2) {
            if (lcContents.equals(Constants.htmlColourNames[i2])) {
                if (Constants.htmlColourValues[i2].length() >= Constants.htmlColourNames[i2].length()) break;
                this.contents = Constants.htmlColourValues[i2];
                break;
            }
            if (!lcContents.equals(Constants.htmlColourValues[i2]) || Constants.htmlColourNames[i2].length() >= Constants.htmlColourValues[i2].length()) continue;
            this.contents = Constants.htmlColourNames[i2];
        }
    }

    private void simplifyHexColours() {
        StringBuffer newContents = new StringBuffer();
        Pattern pattern = Pattern.compile("#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])");
        Matcher matcher = pattern.matcher(this.contents);
        while (matcher.find()) {
            if (matcher.group(1).equalsIgnoreCase(matcher.group(2)) && matcher.group(3).equalsIgnoreCase(matcher.group(4)) && matcher.group(5).equalsIgnoreCase(matcher.group(6))) {
                matcher.appendReplacement(newContents, "#" + matcher.group(1).toLowerCase() + matcher.group(3).toLowerCase() + matcher.group(5).toLowerCase());
                continue;
            }
            matcher.appendReplacement(newContents, matcher.group().toLowerCase());
        }
        matcher.appendTail(newContents);
        this.contents = newContents.toString();
    }

    public String toString() {
        return this.contents;
    }
}

