/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework;

import eu.stamp_project.testrunner.test_framework.TestFrameworkSupport;
import eu.stamp_project.testrunner.test_framework.assertions.IsAssertInvocationFilter;
import java.util.Arrays;
import java.util.List;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.visitor.filter.TypeFilter;

public abstract class AbstractTestFramework
implements TestFrameworkSupport {
    private IsAssertInvocationFilter filter;
    protected final List<String> qualifiedNameOfAssertClasses;
    protected final String qualifiedNameOfAssertClass;

    public AbstractTestFramework(String ... qualifiedNameOfAssertClasses) {
        this.qualifiedNameOfAssertClasses = Arrays.asList(qualifiedNameOfAssertClasses);
        this.qualifiedNameOfAssertClass = this.qualifiedNameOfAssertClasses.get(0);
        this.filter = new IsAssertInvocationFilter(this.qualifiedNameOfAssertClasses);
    }

    @Override
    public boolean isAssert(CtInvocation<?> invocation) {
        return this.filter.isAssert(invocation);
    }

    @Override
    public boolean isAssert(CtStatement candidate) {
        if (candidate instanceof CtInvocation) {
            return this.filter.isAssert(candidate);
        }
        return false;
    }

    @Override
    public boolean isInAssert(CtElement candidate) {
        if (candidate.getParent(CtInvocation.class) != null) {
            return this.isAssert(candidate.getParent(CtInvocation.class));
        }
        return false;
    }

    public String getCorrectExpectedNameOfException(CtMethod<?> test) {
        String expectedName = "expected";
        List<CtCatch> catches = test.getElements(new TypeFilter<CtCatch>(CtCatch.class));
        if (catches.isEmpty()) {
            return expectedName;
        }
        return expectedName + "_" + catches.size();
    }
}

