/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework.assertions;

import java.util.List;
import java.util.regex.Pattern;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.filter.TypeFilter;

public class IsAssertInvocationFilter {
    private final List<String> assertionClassesName;
    private final int depth;

    public IsAssertInvocationFilter(List<String> assertionClassesName) {
        this.assertionClassesName = assertionClassesName;
        this.depth = 3;
    }

    public IsAssertInvocationFilter(List<String> assertionClassesName, int depth) {
        this.assertionClassesName = assertionClassesName;
        this.depth = depth;
    }

    public boolean isAssert(CtStatement candidate) {
        return candidate instanceof CtInvocation && this.isAssert((CtInvocation)candidate);
    }

    public boolean isAssert(CtInvocation<?> invocation) {
        return this._isAssert(invocation) || invocation.getExecutable().getDeclaration() != null && !invocation.getExecutable().getDeclaration().getElements(new HasAssertInvocationFilter(this.depth)).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _isAssert(CtInvocation<?> invocation) {
        String qualifiedNameOfDeclaringType;
        if (invocation == null || invocation.getExecutable() == null || invocation.getExecutable().getDeclaringType() == null || invocation.getExecutable().getDeclaringType().getTypeDeclaration() == null) {
            return false;
        }
        if (invocation.getExecutable().getDeclaringType().getPackage() == null) {
            if (invocation.getExecutable().getDeclaringType().getTopLevelType() == null) return false;
            qualifiedNameOfDeclaringType = invocation.getExecutable().getDeclaringType().getTopLevelType().getQualifiedName();
            return this.assertionClassesName.stream().anyMatch(assertionClassName -> Pattern.compile(assertionClassName).matcher(qualifiedNameOfDeclaringType).matches());
        } else {
            qualifiedNameOfDeclaringType = invocation.getExecutable().getDeclaringType().getQualifiedName();
        }
        return this.assertionClassesName.stream().anyMatch(assertionClassName -> Pattern.compile(assertionClassName).matcher(qualifiedNameOfDeclaringType).matches());
    }

    private boolean containsMethodCallToAssertion(CtInvocation<?> invocation, int deep) {
        if (invocation.getExecutable() == null || invocation.getExecutable().getDeclaringType() == null || invocation.getExecutable().getDeclaringType().getTypeDeclaration() == null) {
            return false;
        }
        CtMethod method = invocation.getExecutable().getDeclaringType().getTypeDeclaration().getMethod(invocation.getExecutable().getType(), invocation.getExecutable().getSimpleName(), invocation.getExecutable().getParameters().toArray(new CtTypeReference[0]));
        return method != null && !method.getElements(new HasAssertInvocationFilter(deep - 1)).isEmpty();
    }

    private class HasAssertInvocationFilter
    extends TypeFilter<CtInvocation<?>> {
        int deep;

        HasAssertInvocationFilter(int deep) {
            super(CtInvocation.class);
            this.deep = deep;
        }

        @Override
        public boolean matches(CtInvocation<?> element) {
            return this.deep >= 0 && (IsAssertInvocationFilter.this._isAssert(element) || IsAssertInvocationFilter.this.containsMethodCallToAssertion(element, this.deep));
        }
    }
}

