/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework.implementations;

import eu.stamp_project.testrunner.test_framework.AbstractTestFrameworkDecorator;
import eu.stamp_project.testrunner.test_framework.assertions.AssertEnum;
import java.util.Collections;
import java.util.List;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;

public class GoogleTruthTestFramework
extends AbstractTestFrameworkDecorator {
    private static final String ASSERT_THAT = "assertThat";
    public static final String ASSERT_NULL = "isNull";
    public static final String ASSERT_NOT_NULL = "isNotNull";
    public static final String ASSERT_TRUE = "isTrue";
    public static final String ASSERT_FALSE = "isFalse";
    public static final String ASSERT_EQUALS = "isEqualTo";
    public static final String ASSERT_NOT_EQUALS = "isNotEqualTo";

    public GoogleTruthTestFramework() {
        super("com.google.common.truth.Truth");
    }

    @Override
    public CtInvocation<?> buildInvocationToAssertion(CtMethod<?> testMethod, AssertEnum assertion, List<CtExpression> arguments) {
        Factory factory = testMethod.getFactory();
        CtInvocation<?> assertThat = this.createAssertThat(arguments.get(arguments.size() - 1));
        CtInvocation invocation = factory.createInvocation();
        CtExecutableReference executableReference = factory.Core().createExecutableReference();
        executableReference.setSimpleName(assertion.toStringAccordingToClass(this.getClass()));
        executableReference.setDeclaringType(factory.Type().createReference(assertion.toStringAccordingToClass(this.getClass())));
        invocation.setExecutable(executableReference);
        if (arguments.size() > 1) {
            invocation.setArguments(Collections.singletonList(arguments.get(0)));
        }
        invocation.setType(factory.Type().voidPrimitiveType());
        invocation.setTarget(assertThat);
        invocation.putMetadata("A-Amplification", true);
        return invocation;
    }

    private CtInvocation<?> createAssertThat(CtExpression<?> actual) {
        Factory factory = actual.getFactory();
        CtInvocation invocation = factory.createInvocation();
        CtExecutableReference executableReference = factory.Core().createExecutableReference();
        executableReference.setStatic(true);
        executableReference.setSimpleName(ASSERT_THAT);
        executableReference.setDeclaringType(factory.Type().createReference(this.qualifiedNameOfAssertClass));
        invocation.setExecutable(executableReference);
        invocation.setArguments(Collections.singletonList(actual));
        invocation.setType(factory.Type().voidPrimitiveType());
        invocation.setTarget(factory.createTypeAccess(factory.Type().createReference(this.qualifiedNameOfAssertClass)));
        invocation.putMetadata("A-Amplification", true);
        return invocation;
    }

    @Override
    public boolean isIgnored(CtElement candidate) {
        return false;
    }
}

