/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework.implementations.junit;

import eu.stamp_project.testrunner.test_framework.implementations.junit.JUnitSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtReturn;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;

public class JUnit3Support
extends JUnitSupport {
    public JUnit3Support() {
        super("junit.framework.TestCase", "junit.framework.Assert");
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationAfterClass() {
        return "";
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationTest() {
        return "";
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationIgnore() {
        return "";
    }

    @Override
    public boolean isIgnored(CtElement candidate) {
        return candidate instanceof CtMethod ? !((CtMethod)candidate).getSimpleName().startsWith("test") : false;
    }

    @Override
    protected boolean isATest(CtMethod<?> candidate) {
        CtType testClass = candidate.getParent(CtType.class);
        if (testClass == null) {
            return false;
        }
        return this.matchOneSuperClassToAssertClass((CtTypeReference<?>)testClass.getReference()) && candidate.getSimpleName().startsWith("test");
    }

    private boolean matchOneSuperClassToAssertClass(CtTypeReference<?> currentTestClass) {
        if (currentTestClass.getSuperclass() == null) {
            return false;
        }
        return currentTestClass.getQualifiedName().equals(this.qualifiedNameOfAssertClass) || this.matchOneSuperClassToAssertClass(currentTestClass.getSuperclass());
    }

    @Override
    public void generateAfterClassToSaveObservations(CtType<?> testClass, List<CtMethod<?>> testsToRun) {
        Factory factory = testClass.getFactory();
        CtMethod suiteMethod = factory.createMethod();
        suiteMethod.setModifiers(new HashSet<ModifierKind>(Arrays.asList(ModifierKind.PUBLIC, ModifierKind.STATIC)));
        suiteMethod.setSimpleName("suite");
        suiteMethod.setType(factory.createCtTypeReference(Test.class));
        CtClass testSetupClass = factory.Class().create("junit.extensions.TestSetup");
        CtParameter<Class> parameter = factory.createParameter();
        parameter.setType(factory.Type().createReference(Class.class));
        parameter.setSimpleName("test");
        testSetupClass.addConstructor(factory.createConstructor(testSetupClass, Collections.emptySet(), Collections.singletonList(parameter), Collections.emptySet()));
        CtCodeSnippetExpression<Class> parameterValue = factory.createCodeSnippetExpression(testClass.getQualifiedName() + ".class");
        parameterValue.setType(factory.Type().createReference(Class.class));
        CtConstructorCall constructorCall = factory.createConstructorCall(factory.createCtTypeReference(TestSuite.class), parameterValue);
        CtNewClass testSetupNewClass = factory.Code().createNewClass(testSetupClass, parameterValue);
        CtReturn returnStatement = factory.createReturn();
        returnStatement.setReturnedExpression(testSetupNewClass);
        suiteMethod.setBody(returnStatement);
        CtMethod<Void> tearDown = factory.createMethod();
        tearDown.setModifiers(new HashSet<ModifierKind>(Collections.singletonList(ModifierKind.PROTECTED)));
        tearDown.setSimpleName("tearDown");
        tearDown.addThrownType(factory.createCtTypeReference(Exception.class));
        tearDown.setType(factory.Type().VOID_PRIMITIVE);
        this.createCallToSaveAndInsertAtTheEnd(factory, tearDown);
        testSetupNewClass.getAnonymousClass().addMethod(tearDown);
        testClass.addMethod(suiteMethod);
    }
}

