/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework.implementations.junit;

import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.test_framework.AbstractTestFramework;
import eu.stamp_project.testrunner.test_framework.assertions.AssertEnum;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public abstract class JUnitSupport
extends AbstractTestFramework {
    public static final String ASSERT_NULL = "assertNull";
    public static final String ASSERT_NOT_NULL = "assertNotNull";
    public static final String ASSERT_TRUE = "assertTrue";
    public static final String ASSERT_FALSE = "assertFalse";
    public static final String ASSERT_EQUALS = "assertEquals";
    public static final String ASSERT_NOT_EQUALS = "assertNotEquals";
    public static final String ASSERT_ARRAY_EQUALS = "assertArrayEquals";

    protected abstract String getFullQualifiedNameOfAnnotationTest();

    protected abstract String getFullQualifiedNameOfAnnotationIgnore();

    protected abstract String getFullQualifiedNameOfAnnotationAfterClass();

    @Override
    public boolean isIgnored(CtElement candidate) {
        return this.hasAnnotation(this.getFullQualifiedNameOfAnnotationIgnore(), candidate);
    }

    protected boolean isATest(CtMethod<?> candidate) {
        return this.hasAnnotation(this.getFullQualifiedNameOfAnnotationTest(), candidate);
    }

    public JUnitSupport(String ... qualifiedNameOfAssertClass) {
        super(qualifiedNameOfAssertClass);
    }

    @Override
    public boolean isInAssert(CtElement candidate) {
        if (candidate.getParent(CtInvocation.class) != null) {
            return this.isAssert(candidate.getParent(CtInvocation.class));
        }
        return false;
    }

    @Override
    public boolean isTest(CtMethod<?> candidate) {
        if (candidate == null) {
            return false;
        }
        if (this.isIgnored(candidate)) {
            return false;
        }
        if (candidate.isImplicit() || candidate.getBody() == null || candidate.getBody().getStatements().size() == 0 || !candidate.getParameters().isEmpty()) {
            return false;
        }
        return this.isATest(candidate);
    }

    private boolean hasAnnotation(String fullQualifiedNameOfAnnotation, CtElement candidate) {
        return candidate.getAnnotations().stream().anyMatch(ctAnnotation -> ctAnnotation.getAnnotationType().getQualifiedName().equals(fullQualifiedNameOfAnnotation));
    }

    @Override
    public CtInvocation<?> buildInvocationToAssertion(CtMethod<?> testMethod, AssertEnum assertion, List<CtExpression> arguments) {
        Factory factory = testMethod.getFactory();
        CtInvocation invocation = factory.createInvocation();
        CtExecutableReference executableReference = factory.Core().createExecutableReference();
        executableReference.setStatic(true);
        executableReference.setSimpleName(assertion.toStringAccordingToClass(JUnitSupport.class));
        executableReference.setDeclaringType(factory.Type().createReference(this.qualifiedNameOfAssertClass));
        invocation.setExecutable(executableReference);
        invocation.setArguments(arguments);
        invocation.setType(factory.Type().voidPrimitiveType());
        invocation.setTarget(factory.createTypeAccess(factory.Type().createReference(this.qualifiedNameOfAssertClass)));
        invocation.putMetadata("A-Amplification", true);
        return invocation;
    }

    @Override
    public CtMethod<?> prepareTestMethod(CtMethod<?> testMethod) {
        if (testMethod.getThrownTypes().isEmpty()) {
            testMethod.addThrownType(testMethod.getFactory().Type().createReference(Exception.class));
        }
        return testMethod;
    }

    @Override
    public CtMethod<?> generateExpectedExceptionsBlock(CtMethod<?> test, Failure failure, int numberOfFail) {
        CtStatement failStatement;
        Factory factory = test.getFactory();
        String[] split = failure.fullQualifiedNameOfException.split("\\.");
        String simpleNameOfException = split[split.length - 1];
        CtTry tryBlock = factory.Core().createTry();
        tryBlock.setBody(test.getBody());
        CtType assertClass = factory.createReference(this.qualifiedNameOfAssertClass).getTypeDeclaration();
        if (assertClass.getMethod("fail", new CtTypeReference[0]) == null) {
            String snippet = this.qualifiedNameOfAssertClass + ".fail(\"" + test.getSimpleName() + " should have thrown " + simpleNameOfException + "\")";
            failStatement = factory.Code().createCodeSnippetStatement(snippet);
        } else {
            CtMethod fail = assertClass.getMethod("fail", new CtTypeReference[0]);
            CtTypeAccess assertTypeAccess = factory.createTypeAccess(assertClass.getReference());
            failStatement = (CtStatement)factory.createInvocation((CtExpression<?>)assertTypeAccess, fail.getReference(), new CtExpression[0]).addArgument(factory.createLiteral(test.getSimpleName() + " should have thrown " + simpleNameOfException));
        }
        tryBlock.getBody().addStatement(failStatement);
        CtCatch ctCatch = factory.Core().createCatch();
        CtTypeReference exceptionType = factory.Type().createReference(failure.fullQualifiedNameOfException);
        ctCatch.setParameter(factory.Code().createCatchVariable(exceptionType, this.getCorrectExpectedNameOfException(test), new ModifierKind[0]));
        ctCatch.setBody(factory.Core().createBlock());
        ArrayList<CtCatch> catchers = new ArrayList<CtCatch>(1);
        catchers.add(ctCatch);
        this.addAssertionOnException(test, ctCatch, failure);
        tryBlock.setCatchers(catchers);
        CtBlock body = factory.Core().createBlock();
        body.addStatement(tryBlock);
        test.setBody(body);
        test.setSimpleName(test.getSimpleName() + "_failAssert" + numberOfFail);
        return test;
    }

    private void addAssertionOnException(CtMethod<?> testMethod, CtCatch ctCatch, Failure failure) {
        Factory factory = ctCatch.getFactory();
        CtCatchVariable<? extends Throwable> parameter = ctCatch.getParameter();
        CtInvocation getMessage = factory.createInvocation((CtExpression<?>)factory.createVariableRead(parameter.getReference(), false), factory.Class().get((Class)Throwable.class).getMethodsByName("getMessage").get(0).getReference(), new CtExpression[0]);
    }

    @Override
    public void generateAfterClassToSaveObservations(CtType<?> testClass, List<CtMethod<?>> testsToRun) {
        Factory factory = testClass.getFactory();
        CtMethod<Void> afterClassMethod = testClass.getMethods().stream().filter(method -> method.getAnnotations().stream().anyMatch(ctAnnotation -> this.getFullQualifiedNameOfAnnotationAfterClass().equals(ctAnnotation.getAnnotationType().getQualifiedName()))).findFirst().orElse(this.initAfterClassMethod(factory));
        testClass.addMethod(afterClassMethod);
    }

    protected void createCallToSaveAndInsertAtTheEnd(Factory factory, CtMethod<?> afterClassMethod) {
    }

    private CtMethod<Void> initAfterClassMethod(Factory factory) {
        CtMethod<Void> afterClassMethod = factory.createMethod();
        afterClassMethod.setType(factory.Type().VOID_PRIMITIVE);
        afterClassMethod.addModifier(ModifierKind.PUBLIC);
        afterClassMethod.addModifier(ModifierKind.STATIC);
        afterClassMethod.setSimpleName("afterClass");
        CtAnnotation annotation = factory.createAnnotation();
        annotation.setAnnotationType((CtTypeReference<Annotation>)factory.Annotation().create(this.getFullQualifiedNameOfAnnotationAfterClass()).getReference());
        afterClassMethod.addAnnotation(annotation);
        afterClassMethod.setBody(factory.createBlock());
        return afterClassMethod;
    }
}

