/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.index;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.core.index.JavaIndexer;
import org.eclipse.osgi.util.NLS;

public class JavaIndexerApplication
implements IApplication {
    private String jarToIndex;
    private String indexFile;
    private boolean verbose = false;
    private static final String PDE_LAUNCH = "-pdelaunch";
    private static final String ARG_HELP = "-help";
    private static final String ARG_VERBOSE = "-verbose";
    private static final String ARG_OUTPUT = "-output";

    private void displayHelp() {
        System.out.println(Messages.bind(Messages.CommandLineUsage));
    }

    private void displayError(String message) {
        System.out.println(message);
        System.out.println();
        this.displayHelp();
    }

    private boolean processCommandLine(String[] argsArray) {
        ArrayList<String> args = new ArrayList<String>();
        int i2 = 0;
        int max = argsArray.length;
        while (i2 < max) {
            args.add(argsArray[i2]);
            ++i2;
        }
        int index = 0;
        int argCount = argsArray.length;
        while (index < argCount) {
            String currentArg;
            if (PDE_LAUNCH.equals(currentArg = argsArray[index++])) continue;
            if (ARG_HELP.equals(currentArg)) {
                this.displayHelp();
                return false;
            }
            if (ARG_VERBOSE.equals(currentArg)) {
                this.verbose = true;
                continue;
            }
            if (ARG_OUTPUT.equals(currentArg)) {
                if (this.indexFile != null) {
                    this.displayError(Messages.bind(Messages.CommandLineOnlyOneOutputError));
                    return false;
                }
                if (index == argCount) {
                    this.displayError(Messages.bind(Messages.CommandLineOutputTakesArgs));
                    return false;
                }
                this.indexFile = argsArray[index++];
                continue;
            }
            if (this.jarToIndex != null) {
                this.displayError(Messages.bind(Messages.CommandLineOnlyOneJarError));
                return false;
            }
            this.jarToIndex = currentArg;
        }
        return true;
    }

    public Object start(IApplicationContext context) throws Exception {
        boolean execute = this.processCommandLine((String[])context.getArguments().get("application.args"));
        if (execute) {
            if (this.jarToIndex != null && this.indexFile != null) {
                File f = new File(this.jarToIndex);
                if (f.exists()) {
                    if (this.verbose) {
                        System.out.println(Messages.bind(Messages.CommandLineProcessing, this.indexFile, this.jarToIndex));
                    }
                    try {
                        JavaIndexer.generateIndexForJar(this.jarToIndex, this.indexFile);
                    }
                    catch (IOException e) {
                        System.out.println(Messages.bind(Messages.CaughtException, "IOException", e.getLocalizedMessage()));
                    }
                } else {
                    System.out.println(Messages.bind(Messages.CommandLineJarFileNotExist, this.jarToIndex));
                }
            } else if (this.jarToIndex == null) {
                System.out.println(Messages.bind(Messages.CommandLineJarNotSpecified));
            } else if (this.indexFile == null) {
                System.out.println(Messages.bind(Messages.CommandLineIndexFileNotSpecified));
            }
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    private static final class Messages
    extends NLS {
        private static final String MESSAGES_NAME = "org.eclipse.jdt.core.index.messages";
        public static String CommandLineProcessing;
        public static String CommandLineUsage;
        public static String CommandLineOnlyOneOutputError;
        public static String CommandLineOutputTakesArgs;
        public static String CommandLineOnlyOneJarError;
        public static String CommandLineJarNotSpecified;
        public static String CommandLineIndexFileNotSpecified;
        public static String CaughtException;
        public static String CommandLineJarFileNotExist;

        static {
            NLS.initializeMessages((String)MESSAGES_NAME, Messages.class);
        }

        private Messages() {
        }

        public static String bind(String message) {
            return Messages.bind(message, null);
        }

        public static String bind(String message, Object binding) {
            return Messages.bind(message, new Object[]{binding});
        }

        public static String bind(String message, Object binding1, Object binding2) {
            return Messages.bind(message, new Object[]{binding1, binding2});
        }

        public static String bind(String message, Object[] bindings) {
            return MessageFormat.format(message, bindings);
        }
    }
}

