/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.internal.core.JarEntryResource;

public class JarEntryDirectory
extends JarEntryResource {
    private IJarEntryResource[] children;

    public JarEntryDirectory(String simpleName) {
        super(simpleName);
    }

    @Override
    public JarEntryResource clone(Object newParent) {
        JarEntryDirectory dir = new JarEntryDirectory(this.simpleName);
        dir.setParent(newParent);
        int length = this.children.length;
        if (length > 0) {
            IJarEntryResource[] newChildren = new IJarEntryResource[length];
            int i2 = 0;
            while (i2 < length) {
                JarEntryResource child = (JarEntryResource)this.children[i2];
                newChildren[i2] = child.clone(dir);
                ++i2;
            }
            dir.setChildren(newChildren);
        }
        return dir;
    }

    @Override
    public IJarEntryResource[] getChildren() {
        return this.children;
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public void setChildren(IJarEntryResource[] children) {
        this.children = children;
    }

    public String toString() {
        return "JarEntryDirectory[" + this.getEntryName() + "]";
    }
}

