/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.BinaryLambdaExpression;
import org.eclipse.jdt.internal.core.BinaryLambdaMethod;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LambdaMethod;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.SourceMethodInfo;

public class LambdaFactory {
    public static LambdaExpression createLambdaExpression(JavaElement parent, org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        if (LambdaFactory.isBinaryMember(parent)) {
            return new BinaryLambdaExpression(parent, lambdaExpression);
        }
        return new LambdaExpression(parent, lambdaExpression);
    }

    public static LambdaExpression createLambdaExpression(JavaElement parent, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        if (LambdaFactory.isBinaryMember(parent)) {
            return new BinaryLambdaExpression(parent, interphase, sourceStart, sourceEnd, arrowPosition);
        }
        return new LambdaExpression(parent, interphase, sourceStart, sourceEnd, arrowPosition);
    }

    public static LambdaMethod createLambdaMethod(JavaElement parent, org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int length = lambdaExpression.descriptor.parameters.length;
        String[] parameterTypes = new String[length];
        int i2 = 0;
        while (i2 < length) {
            parameterTypes[i2] = LambdaFactory.getTypeSignature(manager, lambdaExpression.descriptor.parameters[i2]);
            ++i2;
        }
        String[] parameterNames = new String[length];
        int i3 = 0;
        while (i3 < length) {
            parameterNames[i3] = manager.intern(new String(lambdaExpression.arguments[i3].name));
            ++i3;
        }
        String returnType = LambdaFactory.getTypeSignature(manager, lambdaExpression.descriptor.returnType);
        String selector = manager.intern(new String(lambdaExpression.descriptor.selector));
        String key = new String(lambdaExpression.descriptor.computeUniqueKey());
        LambdaMethod lambdaMethod = LambdaFactory.createLambdaMethod(parent, selector, key, lambdaExpression.sourceStart, lambdaExpression.sourceEnd, lambdaExpression.arrowPosition, parameterTypes, parameterNames, returnType);
        length = lambdaExpression.arguments.length;
        ILocalVariable[] parameters = new ILocalVariable[length];
        int i4 = 0;
        while (i4 < length) {
            Argument argument = lambdaExpression.arguments[i4];
            String signature = manager.intern(new String(lambdaExpression.descriptor.parameters[i4].signature()));
            parameters[i4] = new LocalVariable(lambdaMethod, new String(argument.name), argument.declarationSourceStart, argument.declarationSourceEnd, argument.sourceStart, argument.sourceEnd, signature, null, argument.modifiers, true);
            ++i4;
        }
        lambdaMethod.elementInfo.arguments = parameters;
        return lambdaMethod;
    }

    public static LambdaMethod createLambdaMethod(JavaElement parent, String selector, String key, int sourceStart, int sourceEnd, int arrowPosition, String[] parameterTypes, String[] parameterNames, String returnType) {
        SourceMethodInfo info = null;
        boolean isBinary = parent instanceof BinaryLambdaExpression;
        info = new SourceMethodInfo();
        info.setSourceRangeStart(sourceStart);
        info.setSourceRangeEnd(sourceEnd);
        info.setFlags(0);
        info.setNameSourceStart(sourceStart);
        info.setNameSourceEnd(arrowPosition);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int length = parameterNames.length;
        char[][] argumentNames = new char[length][];
        int i2 = 0;
        while (i2 < length) {
            argumentNames[i2] = manager.intern(parameterNames[i2].toCharArray());
            ++i2;
        }
        info.setArgumentNames(argumentNames);
        info.setReturnType(manager.intern(Signature.toCharArray(returnType.toCharArray())));
        info.setExceptionTypeNames(CharOperation.NO_CHAR_CHAR);
        info.arguments = null;
        return isBinary ? new BinaryLambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info) : new LambdaMethod(parent, selector, key, sourceStart, parameterTypes, parameterNames, returnType, info);
    }

    private static String getTypeSignature(JavaModelManager manager, TypeBinding type) {
        char[] signature = type.genericTypeSignature();
        signature = CharOperation.replaceOnCopy(signature, '/', '.');
        return manager.intern(new String(signature));
    }

    private static boolean isBinaryMember(JavaElement element) {
        return element instanceof BinaryMember;
    }
}

