/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IMethodParametersAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;

public class MethodParametersAttribute
extends ClassFileAttribute
implements IMethodParametersAttribute {
    private static final char[][] NO_NAMES = new char[0][];
    private static final short[] NO_ACCES_FLAGS = new short[0];
    private final int numberOfEntries;
    private final char[][] names;
    private final short[] accessFlags;

    MethodParametersAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.numberOfEntries = length = this.u1At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = offset + 7;
            this.names = new char[length][];
            this.accessFlags = new short[length];
            int i2 = 0;
            while (i2 < length) {
                int nameIndex = this.u2At(classFileBytes, 0, readOffset);
                int mask = this.u2At(classFileBytes, 2, readOffset);
                readOffset += 4;
                if (nameIndex != 0) {
                    IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(nameIndex);
                    if (constantPoolEntry.getKind() != 1) {
                        throw new ClassFormatException(3);
                    }
                    this.names[i2] = constantPoolEntry.getUtf8Value();
                } else {
                    this.names[i2] = null;
                }
                this.accessFlags[i2] = (short)(mask & 0xFFFF);
                ++i2;
            }
        } else {
            this.names = NO_NAMES;
            this.accessFlags = NO_ACCES_FLAGS;
        }
    }

    @Override
    public int getMethodParameterLength() {
        return this.numberOfEntries;
    }

    @Override
    public char[] getParameterName(int i2) {
        return this.names[i2];
    }

    @Override
    public short getAccessFlags(int i2) {
        return this.accessFlags[i2];
    }
}

