/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class KotlinWhenStringFilter
implements IFilter {
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i2 : methodNode.instructions) {
            matcher.match(i2, output);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(AbstractInsnNode start, IFilterOutput output) {
            int hashCodes;
            LabelNode defaultLabel;
            if (25 != start.getOpcode()) {
                return;
            }
            this.cursor = start;
            this.nextIsInvoke(182, "java/lang/String", "hashCode", "()I");
            this.nextIsSwitch();
            if (this.cursor == null) {
                return;
            }
            this.vars.put("s", (VarInsnNode)start);
            AbstractInsnNode s = this.cursor;
            if (s.getOpcode() == 171) {
                LookupSwitchInsnNode lookupSwitch = (LookupSwitchInsnNode)this.cursor;
                defaultLabel = lookupSwitch.dflt;
                hashCodes = lookupSwitch.labels.size();
            } else {
                TableSwitchInsnNode tableSwitch = (TableSwitchInsnNode)this.cursor;
                defaultLabel = tableSwitch.dflt;
                hashCodes = tableSwitch.labels.size();
            }
            if (hashCodes == 0) {
                return;
            }
            HashSet<AbstractInsnNode> replacements = new HashSet<AbstractInsnNode>();
            replacements.add(Matcher.skipNonOpcodes(defaultLabel));
            for (int i2 = 1; i2 <= hashCodes; ++i2) {
                JumpInsnNode jump;
                block9: {
                    do {
                        this.nextIsVar(25, "s");
                        this.nextIs(18);
                        this.nextIsInvoke(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                        this.nextIs(153);
                        jump = (JumpInsnNode)this.cursor;
                        this.next();
                        if (this.cursor == null) {
                            return;
                        }
                        if (this.cursor.getOpcode() != 167) break block9;
                        replacements.add(Matcher.skipNonOpcodes(((JumpInsnNode)this.cursor).label));
                    } while (jump.label != defaultLabel);
                    continue;
                }
                if (i2 == hashCodes && jump.label == defaultLabel) {
                    replacements.add(this.cursor);
                    this.cursor = jump;
                    continue;
                }
                return;
            }
            output.ignore(s.getNext(), this.cursor);
            output.replaceBranches(s, replacements);
        }
    }
}

