/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.input;

import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.CharAppender;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.input.CharInput;

public class DefaultCharAppender
implements CharAppender {
    final int whitespaceRangeStart;
    final char[] emptyChars;
    char[] chars;
    int index;
    final String emptyValue;
    int whitespaceCount;

    public DefaultCharAppender(int maxLength, String emptyValue, int whitespaceRangeStart) {
        this.whitespaceRangeStart = whitespaceRangeStart;
        this.chars = new char[maxLength];
        this.emptyValue = emptyValue;
        this.emptyChars = (char[])(emptyValue == null ? null : emptyValue.toCharArray());
    }

    @Override
    public void appendIgnoringPadding(char ch, char padding) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch == padding ? ++this.whitespaceCount : 0;
    }

    @Override
    public void appendIgnoringWhitespaceAndPadding(char ch, char padding) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch == padding || ch <= ' ' && this.whitespaceRangeStart < ch ? ++this.whitespaceCount : 0;
    }

    @Override
    public void appendIgnoringWhitespace(char ch) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch <= ' ' && this.whitespaceRangeStart < ch ? ++this.whitespaceCount : 0;
    }

    @Override
    public void append(char ch) {
        this.chars[this.index++] = ch;
    }

    @Override
    public final void append(int ch) {
        if (ch < 65536) {
            this.append((char)ch);
        } else {
            int off = ch - 65536;
            this.append((char)((off >>> 10) + 55296));
            this.append((char)((off & 0x3FF) + 56320));
        }
    }

    @Override
    public final void append(int[] ch) {
        for (int i2 = 0; i2 < ch.length; ++i2) {
            this.append(ch[i2]);
        }
    }

    @Override
    public String getAndReset() {
        String out = this.emptyValue;
        if (this.index > this.whitespaceCount) {
            out = new String(this.chars, 0, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    @Override
    public final String toString() {
        if (this.index <= this.whitespaceCount) {
            return this.emptyValue;
        }
        return new String(this.chars, 0, this.index - this.whitespaceCount);
    }

    @Override
    public final int length() {
        return this.index - this.whitespaceCount;
    }

    @Override
    public char[] getCharsAndReset() {
        char[] out = this.emptyChars;
        if (this.index > this.whitespaceCount) {
            int length = this.index - this.whitespaceCount;
            out = new char[length];
            System.arraycopy(this.chars, 0, out, 0, length);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    @Override
    public final int whitespaceCount() {
        return this.whitespaceCount;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.whitespaceCount = 0;
    }

    public void append(DefaultCharAppender appender) {
        System.arraycopy(appender.chars, 0, this.chars, this.index, appender.index - appender.whitespaceCount);
        this.index += appender.index - appender.whitespaceCount;
        appender.reset();
    }

    @Override
    public final void resetWhitespaceCount() {
        this.whitespaceCount = 0;
    }

    @Override
    public final char[] getChars() {
        return this.chars;
    }

    @Override
    public void fill(char ch, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            this.chars[this.index++] = ch;
        }
    }

    @Override
    public void prepend(char ch) {
        System.arraycopy(this.chars, 0, this.chars, 1, this.index);
        this.chars[0] = ch;
        ++this.index;
    }

    @Override
    public void prepend(char ch1, char ch2) {
        System.arraycopy(this.chars, 0, this.chars, 2, this.index);
        this.chars[0] = ch1;
        this.chars[1] = ch2;
        this.index += 2;
    }

    @Override
    public void prepend(char[] chars) {
        System.arraycopy(this.chars, 0, this.chars, chars.length, this.index);
        System.arraycopy(chars, 0, this.chars, 0, chars.length);
        this.index += chars.length;
    }

    @Override
    public final void updateWhitespace() {
        this.whitespaceCount = 0;
        int i2 = this.index - 1;
        while (i2 >= 0 && this.chars[i2] <= ' ' && this.whitespaceRangeStart < this.chars[i2]) {
            --i2;
            ++this.whitespaceCount;
        }
    }

    @Override
    public char appendUntil(char ch, CharInput input, char stop) {
        while (ch != stop) {
            this.chars[this.index++] = ch;
            ch = input.nextChar();
        }
        return ch;
    }

    @Override
    public char appendUntil(char ch, CharInput input, char stop1, char stop2) {
        while (ch != stop1 && ch != stop2) {
            this.chars[this.index++] = ch;
            ch = input.nextChar();
        }
        return ch;
    }

    @Override
    public char appendUntil(char ch, CharInput input, char stop1, char stop2, char stop3) {
        while (ch != stop1 && ch != stop2 && ch != stop3) {
            this.chars[this.index++] = ch;
            ch = input.nextChar();
        }
        return ch;
    }

    @Override
    public void append(char[] ch, int from, int length) {
        System.arraycopy(ch, from, this.chars, this.index, length);
        this.index += length;
    }

    @Override
    public final void append(char[] ch) {
        this.append(ch, 0, ch.length);
    }

    @Override
    public void append(String string, int from, int to) {
        string.getChars(from, to, this.chars, this.index);
        this.index += to - from;
    }

    @Override
    public final void append(String string) {
        this.append(string, 0, string.length());
    }

    @Override
    public final char charAt(int i2) {
        return this.chars[i2];
    }

    @Override
    public final String subSequence(int from, int to) {
        return new String(this.chars, from, to - from);
    }
}

