/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.pitest.classinfo.ClassName;
import org.pitest.sequence.Match;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class InstructionMatchers {
    public static Match<AbstractInsnNode> anyInstruction() {
        return Match.always();
    }

    public static Match<AbstractInsnNode> notAnInstruction() {
        return InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    }

    public static Match<AbstractInsnNode> opCode(int opcode) {
        return (c, a) -> a.getOpcode() == opcode;
    }

    public static <T extends AbstractInsnNode> Match<AbstractInsnNode> isA(Class<T> cls) {
        return (c, a) -> a.getClass().isAssignableFrom(cls);
    }

    public static Match<AbstractInsnNode> incrementsVariable(SlotRead<Integer> counterVariable) {
        return (context, a) -> a instanceof IincInsnNode && context.retrieve(counterVariable).filter(Predicate.isEqual(((IincInsnNode)a).var)).isPresent();
    }

    public static Match<AbstractInsnNode> anIStore(SlotWrite<Integer> counterVariable) {
        return InstructionMatchers.opCode(54).and(InstructionMatchers.aVariableAccess(counterVariable));
    }

    public static Match<AbstractInsnNode> aVariableAccess(SlotWrite<Integer> counterVariable) {
        return (c, t) -> t instanceof VarInsnNode && c.store(counterVariable, ((VarInsnNode)t).var);
    }

    public static Match<AbstractInsnNode> anIStoreTo(SlotRead<Integer> counterVariable) {
        return InstructionMatchers.opCode(54).and(InstructionMatchers.variableMatches(counterVariable));
    }

    public static Match<AbstractInsnNode> anILoadOf(SlotRead<Integer> counterVariable) {
        return InstructionMatchers.opCode(21).and(InstructionMatchers.variableMatches(counterVariable));
    }

    public static Match<AbstractInsnNode> variableMatches(SlotRead<Integer> counterVariable) {
        return (c, t) -> t instanceof VarInsnNode && c.retrieve(counterVariable).filter(Predicate.isEqual(((VarInsnNode)t).var)).isPresent();
    }

    public static Match<AbstractInsnNode> anIntegerConstant() {
        return InstructionMatchers.opCode(2).or(InstructionMatchers.opCode(3)).or(InstructionMatchers.opCode(4)).or(InstructionMatchers.opCode(5)).or(InstructionMatchers.opCode(6)).or(InstructionMatchers.opCode(7)).or(InstructionMatchers.opCode(8));
    }

    public static Match<AbstractInsnNode> aLabelNode(SlotWrite<LabelNode> slot) {
        return InstructionMatchers.isA(LabelNode.class).and(InstructionMatchers.writeNodeToSlot(slot, LabelNode.class));
    }

    public static Match<AbstractInsnNode> aJump() {
        return InstructionMatchers.isA(JumpInsnNode.class);
    }

    public static Match<AbstractInsnNode> aConditionalJump() {
        return (c, t) -> t instanceof JumpInsnNode && t.getOpcode() != 167 && t.getOpcode() != 168;
    }

    public static Match<AbstractInsnNode> aConditionalJumpTo(Slot<LabelNode> label) {
        return InstructionMatchers.jumpsTo(label.read()).and(InstructionMatchers.aConditionalJump());
    }

    public static <T extends AbstractInsnNode> Match<AbstractInsnNode> writeNodeToSlot(SlotWrite<T> slot, Class<T> clazz) {
        return (c, t) -> {
            if (clazz.isAssignableFrom(t.getClass())) {
                c.store(slot, clazz.cast(t));
                return true;
            }
            return false;
        };
    }

    public static Match<AbstractInsnNode> methodCallThatReturns(ClassName type) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                return ((MethodInsnNode)t).desc.endsWith(type.asInternalName() + ";");
            }
            return false;
        };
    }

    public static Match<AbstractInsnNode> methodCall() {
        return InstructionMatchers.isA(MethodInsnNode.class);
    }

    public static Match<AbstractInsnNode> methodCallNamed(String name) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)t;
                return call.name.equals(name);
            }
            return false;
        };
    }

    public static Match<AbstractInsnNode> methodCallTo(ClassName owner, String name) {
        return (c, t) -> {
            if (t instanceof MethodInsnNode) {
                MethodInsnNode call = (MethodInsnNode)t;
                return call.name.equals(name) && call.owner.equals(owner.asInternalName());
            }
            return false;
        };
    }

    public static Match<AbstractInsnNode> isInstruction(SlotRead<AbstractInsnNode> target) {
        return (c, t) -> c.retrieve(target).get() == t;
    }

    public static Match<AbstractInsnNode> recordTarget(SlotRead<AbstractInsnNode> target, SlotWrite<Boolean> found) {
        return (c, t) -> {
            if (c.retrieve(target).get() == t) {
                c.store(found, true);
            }
            return true;
        };
    }

    private static Match<AbstractInsnNode> storeJumpTarget(SlotWrite<LabelNode> label) {
        return (c, t) -> {
            if (t instanceof JumpInsnNode) {
                c.store(label, ((JumpInsnNode)t).label);
                return true;
            }
            return false;
        };
    }

    public static Match<AbstractInsnNode> jumpsTo(SlotRead<LabelNode> loopStart) {
        return (context, a) -> {
            if (!(a instanceof JumpInsnNode)) {
                return false;
            }
            JumpInsnNode jump = (JumpInsnNode)a;
            return context.retrieve(loopStart).filter(Predicate.isEqual(jump.label)).isPresent();
        };
    }

    public static Match<AbstractInsnNode> jumpsTo(SlotWrite<LabelNode> label) {
        return InstructionMatchers.storeJumpTarget(label);
    }

    public static Match<AbstractInsnNode> gotoLabel(SlotWrite<LabelNode> loopEnd) {
        return InstructionMatchers.opCode(167).and(InstructionMatchers.storeJumpTarget(loopEnd));
    }

    public static Match<AbstractInsnNode> labelNode(SlotRead<LabelNode> loopEnd) {
        return (c, t) -> {
            if (!(t instanceof LabelNode)) {
                return false;
            }
            LabelNode l = (LabelNode)t;
            return c.retrieve(loopEnd).filter(Predicate.isEqual(l)).isPresent();
        };
    }

    public static Match<AbstractInsnNode> debug(String msg) {
        return (context, a) -> {
            context.debug(msg);
            return true;
        };
    }
}

