/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.IOException;
import java.util.Optional;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.ClassPath;
import org.pitest.util.Log;

public class ClassPathByteArraySource
implements ClassByteArraySource {
    private static final Logger LOG = Log.getLogger();
    private final ClassPath classPath;

    public ClassPathByteArraySource() {
        this(new ClassPath());
    }

    public ClassPathByteArraySource(ClassPath classPath) {
        this.classPath = classPath;
    }

    @Override
    public Optional<byte[]> getBytes(String classname) {
        try {
            return Optional.ofNullable(this.classPath.getClassData(classname));
        }
        catch (IOException e) {
            LOG.fine("Could not read class " + classname + ":" + e.getMessage());
            return Optional.empty();
        }
    }
}

