/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.util.Objects;
import org.pitest.classinfo.ClassName;

public final class ClassLine {
    private final ClassName clazz;
    private final int lineNumber;

    public ClassLine(String clazz, int lineNumber) {
        this(ClassName.fromString(clazz), lineNumber);
    }

    public ClassLine(ClassName clazz, int lineNumber) {
        this.clazz = clazz;
        this.lineNumber = lineNumber;
    }

    public ClassName getClassName() {
        return this.clazz;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.lineNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClassLine other = (ClassLine)obj;
        return this.lineNumber == other.lineNumber && Objects.equals(this.clazz, other.clazz);
    }

    public String toString() {
        return "ClassLine [" + this.clazz + ":" + this.lineNumber + "]";
    }
}

