/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import org.pitest.classinfo.BridgeMethodFilter;
import org.pitest.classinfo.MethodFilteringAdapter;
import org.pitest.coverage.AlreadyInstrumentedException;
import org.pitest.coverage.analysis.CoverageAnalyser;
import org.pitest.reloc.asm.ClassWriter;
import org.pitest.reloc.asm.FieldVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import sun.pitest.CodeCoverageStore;

public class CoverageClassVisitor
extends MethodFilteringAdapter {
    private final int classId;
    private int probeCount = 1;
    private String className;
    private boolean foundClinit;
    private boolean isInterface;

    public CoverageClassVisitor(int classId, ClassWriter writer) {
        super(writer, BridgeMethodFilter.INSTANCE);
        this.classId = classId;
    }

    public void registerProbes(int number) {
        this.probeCount += number;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.isInterface = (access & 0x200) != 0;
    }

    @Override
    public MethodVisitor visitMethodIfRequired(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor methodVisitor) {
        if (name.equals("<clinit>")) {
            this.foundClinit = true;
        }
        return new CoverageAnalyser(this, this.classId, this.probeCount, methodVisitor, access, name, desc, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (name.equals("$$pitCoverageProbes")) {
            throw new AlreadyInstrumentedException("Class " + this.getClassName() + " already has coverage instrumentation, but asked to do it again!");
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    @Override
    public void visitEnd() {
        this.addCoverageProbeField();
    }

    private void addCoverageProbeField() {
        super.visitField(this.fieldModifiers(), "$$pitCoverageProbes", "[Z", null, null);
        super.visitField(this.fieldModifiers(), "$$pitCoverageProbeSize", "I", null, this.probeCount + 1);
        if (!this.foundClinit) {
            MethodVisitor clinitMv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
            clinitMv.visitCode();
            this.pushConstant(clinitMv, this.classId);
            this.pushConstant(clinitMv, this.probeCount);
            clinitMv.visitMethodInsn(184, CodeCoverageStore.CLASS_NAME, "getOrRegisterClassProbes", "(II)[Z", false);
            clinitMv.visitFieldInsn(179, this.className, "$$pitCoverageProbes", "[Z");
            clinitMv.visitInsn(177);
            clinitMv.visitMaxs(0, 0);
            clinitMv.visitEnd();
        }
    }

    private int fieldModifiers() {
        if (this.isInterface) {
            return 4121;
        }
        return 4234;
    }

    private void pushConstant(MethodVisitor mv, int value) {
        switch (value) {
            case 0: {
                mv.visitInsn(3);
                break;
            }
            case 1: {
                mv.visitInsn(4);
                break;
            }
            case 2: {
                mv.visitInsn(5);
                break;
            }
            case 3: {
                mv.visitInsn(6);
                break;
            }
            case 4: {
                mv.visitInsn(7);
                break;
            }
            case 5: {
                mv.visitInsn(8);
                break;
            }
            default: {
                if (value <= 127) {
                    mv.visitIntInsn(16, value);
                    break;
                }
                if (value <= Short.MAX_VALUE) {
                    mv.visitIntInsn(17, value);
                    break;
                }
                mv.visitLdcInsn(value);
            }
        }
    }

    public String getClassName() {
        return this.className;
    }
}

