/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.analysis;

import java.util.Objects;
import java.util.Set;

public final class Block {
    private final int firstInstruction;
    private final int lastInstruction;
    private final Set<Integer> lines;

    public Block(int firstInstruction, int lastInstruction, Set<Integer> lines) {
        this.firstInstruction = firstInstruction;
        this.lastInstruction = lastInstruction;
        this.lines = lines;
    }

    public int hashCode() {
        return Objects.hash(this.firstInstruction, this.lastInstruction);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Block other = (Block)obj;
        return this.firstInstruction == other.firstInstruction && this.lastInstruction == other.lastInstruction;
    }

    public String toString() {
        return "Block [firstInstruction=" + this.firstInstruction + ", lastInstruction=" + this.lastInstruction + "]";
    }

    public boolean firstInstructionIs(int ins) {
        return this.firstInstruction == ins;
    }

    public Set<Integer> getLines() {
        return this.lines;
    }

    public int getFirstInstruction() {
        return this.firstInstruction;
    }

    public int getLastInstruction() {
        return this.lastInstruction;
    }
}

