/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.pitest.coverage.analysis.Block;
import org.pitest.reloc.asm.tree.AbstractInsnNode;
import org.pitest.reloc.asm.tree.FrameNode;
import org.pitest.reloc.asm.tree.InsnList;
import org.pitest.reloc.asm.tree.JumpInsnNode;
import org.pitest.reloc.asm.tree.LabelNode;
import org.pitest.reloc.asm.tree.LineNumberNode;
import org.pitest.reloc.asm.tree.LookupSwitchInsnNode;
import org.pitest.reloc.asm.tree.MethodNode;
import org.pitest.reloc.asm.tree.TableSwitchInsnNode;
import org.pitest.reloc.asm.tree.TryCatchBlockNode;

public class ControlFlowAnalyser {
    private static final int LIKELY_NUMBER_OF_LINES_PER_BLOCK = 7;

    public static List<Block> analyze(MethodNode mn) {
        ArrayList<Block> blocks = new ArrayList<Block>(mn.instructions.size());
        Set<LabelNode> jumpTargets = ControlFlowAnalyser.findJumpTargets(mn.instructions);
        ControlFlowAnalyser.addtryCatchBoundaries(mn, jumpTargets);
        HashSet<Integer> blockLines = ControlFlowAnalyser.smallSet();
        int lastLine = Integer.MIN_VALUE;
        int lastInstruction = mn.instructions.size() - 1;
        int blockStart = 0;
        for (int i2 = 0; i2 != mn.instructions.size(); ++i2) {
            AbstractInsnNode ins = mn.instructions.get(i2);
            if (ins instanceof LineNumberNode) {
                LineNumberNode lnn = (LineNumberNode)ins;
                blockLines.add(lnn.line);
                lastLine = lnn.line;
                continue;
            }
            if (jumpTargets.contains(ins) && blockStart != i2) {
                if (blockLines.isEmpty() && blocks.size() > 0 && !((Block)blocks.get(blocks.size() - 1)).getLines().isEmpty()) {
                    blockLines.addAll(((Block)blocks.get(blocks.size() - 1)).getLines());
                }
                blocks.add(new Block(blockStart, i2 - 1, blockLines));
                blockStart = i2;
                blockLines = ControlFlowAnalyser.smallSet();
                continue;
            }
            if (ControlFlowAnalyser.endsBlock(ins)) {
                if (blockLines.isEmpty() && blocks.size() > 0 && !((Block)blocks.get(blocks.size() - 1)).getLines().isEmpty()) {
                    blockLines.addAll(((Block)blocks.get(blocks.size() - 1)).getLines());
                }
                blocks.add(new Block(blockStart, i2, blockLines));
                blockStart = i2 + 1;
                blockLines = ControlFlowAnalyser.smallSet();
                continue;
            }
            if (lastLine == Integer.MIN_VALUE || !ControlFlowAnalyser.isInstruction(ins)) continue;
            blockLines.add(lastLine);
        }
        if (blockStart != lastInstruction) {
            blocks.add(new Block(blockStart, lastInstruction, blockLines));
        }
        return blocks;
    }

    private static HashSet<Integer> smallSet() {
        return new HashSet<Integer>(7);
    }

    private static boolean isInstruction(AbstractInsnNode ins) {
        return !(ins instanceof LabelNode) && !(ins instanceof FrameNode);
    }

    private static void addtryCatchBoundaries(MethodNode mn, Set<LabelNode> jumpTargets) {
        Iterator<TryCatchBlockNode> iterator = mn.tryCatchBlocks.iterator();
        while (iterator.hasNext()) {
            TryCatchBlockNode each;
            TryCatchBlockNode tcb = each = iterator.next();
            jumpTargets.add(tcb.handler);
        }
    }

    private static boolean endsBlock(AbstractInsnNode ins) {
        return ins instanceof JumpInsnNode || ControlFlowAnalyser.isReturn(ins) || ControlFlowAnalyser.isMightThrowException(ins);
    }

    private static boolean isMightThrowException(AbstractInsnNode ins) {
        return ins.getType() == 5;
    }

    private static boolean isReturn(AbstractInsnNode ins) {
        int opcode = ins.getOpcode();
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private static Set<LabelNode> findJumpTargets(InsnList instructions) {
        HashSet<LabelNode> jumpTargets = new HashSet<LabelNode>();
        for (AbstractInsnNode o : instructions) {
            if (o instanceof JumpInsnNode) {
                jumpTargets.add(((JumpInsnNode)o).label);
                continue;
            }
            if (o instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode twn = (TableSwitchInsnNode)o;
                jumpTargets.add(twn.dflt);
                jumpTargets.addAll(twn.labels);
                continue;
            }
            if (!(o instanceof LookupSwitchInsnNode)) continue;
            LookupSwitchInsnNode lsn = (LookupSwitchInsnNode)o;
            jumpTargets.add(lsn.dflt);
            jumpTargets.addAll(lsn.labels);
        }
        return jumpTargets;
    }
}

