/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.OutputStream;
import java.util.Collection;
import org.pitest.coverage.CoverageReceiver;
import org.pitest.coverage.analysis.Block;
import org.pitest.testapi.Description;
import org.pitest.util.ExitCode;
import org.pitest.util.SafeDataOutputStream;
import sun.pitest.CodeCoverageStore;

public class CoveragePipe
implements CoverageReceiver {
    private final SafeDataOutputStream dos;

    public CoveragePipe(OutputStream dos) {
        this.dos = new SafeDataOutputStream(dos);
    }

    @Override
    public synchronized void recordTestOutcome(Description description, boolean wasGreen, int executionTime) {
        Collection<Long> hits = CodeCoverageStore.getHits();
        this.dos.writeByte((byte)16);
        this.dos.write(description);
        this.dos.writeInt(hits.size());
        for (Long each : hits) {
            this.dos.writeLong(each);
        }
        this.dos.writeBoolean(wasGreen);
        this.dos.writeInt(executionTime);
        CodeCoverageStore.reset();
    }

    public synchronized void end(ExitCode exitCode) {
        this.dos.writeByte((byte)64);
        this.dos.writeInt(exitCode.getCode());
        this.dos.flush();
    }

    @Override
    public synchronized void registerClass(int id, String className) {
        this.dos.writeByte((byte)32);
        this.dos.writeInt(id);
        this.dos.writeString(className);
    }

    @Override
    public synchronized void registerProbes(int classId, String methodName, String methodDesc, int firstProbe, int lastProbe, Iterable<Block> blocks) {
        this.dos.writeByte((byte)4);
        this.dos.writeInt(classId);
        this.dos.writeString(methodName);
        this.dos.writeString(methodDesc);
        this.dos.writeInt(firstProbe);
        this.dos.writeInt(lastProbe);
        for (Block b : blocks) {
            this.dos.writeInt(b.getFirstInstruction());
            this.dos.writeInt(b.getLastInstruction());
        }
    }
}

