/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.util.Log;
import org.pitest.util.SafeDataOutputStream;

final class SendData
implements Consumer<SafeDataOutputStream> {
    private static final Logger LOG = Log.getLogger();
    private final CoverageOptions arguments;
    private final List<String> testClasses;

    SendData(CoverageOptions arguments, List<String> testClasses) {
        this.arguments = arguments;
        this.testClasses = testClasses;
    }

    @Override
    public void accept(SafeDataOutputStream dos) {
        this.sendArguments(dos);
        this.sendTests(dos);
    }

    private void sendArguments(SafeDataOutputStream dos) {
        dos.write(this.arguments);
        dos.flush();
    }

    private void sendTests(SafeDataOutputStream dos) {
        LOG.info("Sending " + this.testClasses.size() + " test classes to minion");
        dos.writeInt(this.testClasses.size());
        for (String tc : this.testClasses) {
            dos.writeString(tc);
        }
        dos.flush();
        LOG.info("Sent tests to minion");
    }
}

