/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.dependency;

import java.util.Objects;

final class DependencyAccess {
    private final Member source;
    private final Member dest;

    protected DependencyAccess(Member source, Member dest) {
        this.source = source;
        this.dest = dest;
    }

    public Member getSource() {
        return this.source;
    }

    public Member getDest() {
        return this.dest;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.dest);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyAccess other = (DependencyAccess)obj;
        return Objects.equals(this.source, other.source) && Objects.equals(this.dest, other.dest);
    }

    static class Member
    implements Comparable<Member> {
        private final String owner;
        private final String name;

        protected Member(String owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            return Objects.equals(this.owner, other.owner) && Objects.equals(this.name, other.name);
        }

        @Override
        public int compareTo(Member other) {
            return other.name.compareTo(this.name) * 100 + other.owner.compareTo(this.owner) * 1000;
        }
    }
}

