/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.testapi.TestSuiteFinder;

public class RunnerSuiteFinder
implements TestSuiteFinder {
    @Override
    public List<Class<?>> apply(Class<?> a) {
        try {
            Runner runner = AdaptedJUnitTestUnit.createRunner(a);
            ArrayList<Description> allChildren = new ArrayList<Description>();
            this.flattenChildren(allChildren, runner.getDescription());
            List<Description> suites = FCollection.filter(allChildren, Prelude.or(RunnerSuiteFinder.isSuiteMethodRunner(runner), Description::isSuite));
            Set classes = suites.stream().flatMap(RunnerSuiteFinder.descriptionToTestClass()).collect(Collectors.toSet());
            classes.remove(a);
            return new ArrayList(classes);
        }
        catch (RuntimeException ex) {
            return Collections.emptyList();
        }
    }

    private void flattenChildren(List<Description> allChildren, Description description) {
        for (Description each : description.getChildren()) {
            allChildren.add(each);
            this.flattenChildren(allChildren, each);
        }
    }

    private static Predicate<Description> isSuiteMethodRunner(Runner runner) {
        return a -> SuiteMethod.class.isAssignableFrom(runner.getClass());
    }

    private static Function<Description, Stream<Class<?>>> descriptionToTestClass() {
        return a -> {
            Class<?> clazz = a.getTestClass();
            if (clazz != null) {
                return Stream.of(clazz);
            }
            return Stream.empty();
        };
    }
}

