/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit.adapter;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.model.RunnerBuilder;
import org.pitest.junit.adapter.CustomRunnerExecutor;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.util.Log;
import org.pitest.util.Unchecked;

public class AdaptedJUnitTestUnit
extends AbstractTestUnit {
    private static final Logger LOG = Log.getLogger();
    private final Class<?> clazz;
    private final Optional<Filter> filter;

    public AdaptedJUnitTestUnit(Class<?> clazz, Optional<Filter> filter) {
        super(new Description(AdaptedJUnitTestUnit.createName(clazz, filter), clazz));
        this.clazz = clazz;
        this.filter = filter;
    }

    private static String createName(Class<?> clazz, Optional<Filter> filter) {
        if (filter.isPresent()) {
            return filter.get().describe();
        }
        return clazz.getName();
    }

    @Override
    public void execute(ResultCollector rc) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(this.clazz);
        this.checkForErrorRunner(runner);
        this.filterIfRequired(rc, runner);
        try {
            CustomRunnerExecutor nativeCe = new CustomRunnerExecutor(this.getDescription(), runner, rc);
            nativeCe.run();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error while running adapter JUnit fixture " + this.clazz + " with filter " + this.filter, e);
            throw Unchecked.translateCheckedException(e);
        }
    }

    private void checkForErrorRunner(Runner runner) {
        if (runner instanceof ErrorReportingRunner) {
            LOG.warning("JUnit error for class " + this.clazz + " : " + runner.getDescription());
        }
    }

    private void filterIfRequired(ResultCollector rc, Runner runner) {
        if (this.filter.isPresent()) {
            if (!(runner instanceof Filterable)) {
                LOG.warning("Not able to filter " + runner.getDescription() + ". Mutation may have prevented JUnit from constructing test");
                return;
            }
            Filterable f = (Filterable)((Object)runner);
            try {
                f.filter(this.filter.get());
            }
            catch (NoTestsRemainException e1) {
                rc.notifySkipped(this.getDescription());
                return;
            }
        }
    }

    public static Runner createRunner(Class<?> clazz) {
        RunnerBuilder builder = AdaptedJUnitTestUnit.createRunnerBuilder();
        try {
            return builder.runnerForClass(clazz);
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Error while creating runner for " + clazz, ex);
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private static RunnerBuilder createRunnerBuilder() {
        return new AllDefaultPossibilitiesBuilder(true);
    }

    public String toString() {
        return "AdaptedJUnitTestUnit [clazz=" + this.clazz + ", filter=" + this.filter + "]";
    }
}

