/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit.adapter;

import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;
import org.pitest.testapi.ResultCollector;

class AdaptingRunListener
extends RunListener {
    private final org.pitest.testapi.Description description;
    private final ResultCollector rc;
    private boolean failed = false;

    AdaptingRunListener(org.pitest.testapi.Description description, ResultCollector rc) {
        this.description = description;
        this.rc = rc;
    }

    @Override
    public void testFailure(Failure failure) {
        this.rc.notifyEnd(this.description, failure.getException());
        this.failed = true;
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
    }

    @Override
    public void testIgnored(Description description) {
        this.rc.notifySkipped(this.description);
    }

    @Override
    public void testStarted(Description description) {
        if (this.failed) {
            throw new StoppedByUserException();
        }
        this.rc.notifyStart(this.description);
    }

    @Override
    public void testFinished(Description description) {
        if (!this.failed) {
            this.rc.notifyEnd(this.description);
        }
    }
}

