/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.PrimitiveReturnsMutator;

class PrimitiveEquivalentFilter
implements MutationInterceptor {
    private static final Set<String> MUTATOR_IDS = new HashSet<String>();
    private static final Set<Integer> ZERO_CONSTANTS = new HashSet<Integer>();
    private ClassTree currentClass;

    PrimitiveEquivalentFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, Prelude.not(this.isEquivalent(m)));
    }

    private Predicate<MutationDetails> isEquivalent(Mutater m) {
        return a -> {
            if (!MUTATOR_IDS.contains(a.getMutator())) {
                return false;
            }
            MethodTree method = this.currentClass.methods().stream().filter(MethodMatchers.forLocation(a.getId().getLocation())).findFirst().get();
            return ZERO_CONSTANTS.contains(method.realInstructionBefore(a.getInstructionIndex()).getOpcode());
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    static {
        ZERO_CONSTANTS.add(3);
        ZERO_CONSTANTS.add(9);
        ZERO_CONSTANTS.add(11);
        ZERO_CONSTANTS.add(14);
        MUTATOR_IDS.add(PrimitiveReturnsMutator.PRIMITIVE_RETURN_VALS_MUTATOR.getGloballyUniqueId());
        MUTATOR_IDS.add(BooleanFalseReturnValsMutator.BOOLEAN_FALSE_RETURN.getGloballyUniqueId());
    }
}

