/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.kotlin;

import java.util.Collection;
import java.util.function.Predicate;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class KotlinFilter
implements MutationInterceptor {
    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, Prelude.not(KotlinFilter.isKotlinJunkMutation()));
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
    }

    @Override
    public void end() {
    }

    private static Predicate<MutationDetails> isKotlinJunkMutation() {
        return a -> a.getFilename().toLowerCase().endsWith(".kt") && a.getLineNumber() == 0;
    }
}

