/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.logging;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.logging.LoggingLineScanner;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class LoggingCallsFilter
implements MutationInterceptor {
    private final Set<String> loggingClasses = new HashSet<String>();
    private Set<Integer> lines;

    public LoggingCallsFilter(Collection<String> loggingClasses) {
        FCollection.mapTo(loggingClasses, LoggingCallsFilter.correctFormat(), this.loggingClasses);
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.lines = new HashSet<Integer>();
        for (MethodTree each : clazz.methods()) {
            this.findLoggingLines(each, this.lines);
        }
    }

    private void findLoggingLines(MethodTree each, Set<Integer> lines) {
        each.rawNode().accept(new LoggingLineScanner(lines, this.loggingClasses));
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, Prelude.not(this.isOnLoggingLine()));
    }

    private Predicate<MutationDetails> isOnLoggingLine() {
        return a -> this.lines.contains(a.getClassLine().getLineNumber());
    }

    @Override
    public void end() {
        this.lines = null;
    }

    private static Function<String, String> correctFormat() {
        return a -> a.replace('.', '/');
    }
}

