/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.pitest.mutationtest.config.ReportDirCreationStrategy;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class DirectoryResultOutputStrategy
implements ResultOutputStrategy {
    private final File reportDir;

    public DirectoryResultOutputStrategy(String baseDir, ReportDirCreationStrategy dirCreationStrategy) {
        this.reportDir = dirCreationStrategy.createReportDir(baseDir);
    }

    @Override
    public Writer createWriterForFile(String file) {
        try {
            String directory;
            File directoryFile;
            int fileSepIndex = file.lastIndexOf(File.separatorChar);
            if (fileSepIndex > 0 && !(directoryFile = new File(directory = this.reportDir.getAbsolutePath() + File.separatorChar + file.substring(0, fileSepIndex))).exists()) {
                directoryFile.mkdirs();
            }
            return new BufferedWriter(new FileWriter(this.reportDir.getAbsolutePath() + File.separatorChar + file));
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }
}

