/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.config.PrioritisingTestSuiteFinder;
import org.pitest.mutationtest.config.PrioritisingTestUnitFinder;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestSuiteFinder;
import org.pitest.testapi.TestUnitFinder;

class PrioritisingTestConfiguration
implements Configuration {
    private final List<Configuration> children;
    private final TestUnitFinder finder;
    private final TestSuiteFinder suiteFinder;

    PrioritisingTestConfiguration(List<Configuration> children) {
        this.children = PrioritisingTestConfiguration.pickChildren(children);
        this.finder = this.makeFinder(this.children);
        this.suiteFinder = this.makeSuiteFinder(this.children);
    }

    @Override
    public TestUnitFinder testUnitFinder() {
        return this.finder;
    }

    @Override
    public TestSuiteFinder testSuiteFinder() {
        return this.suiteFinder;
    }

    @Override
    public Optional<PitHelpError> verifyEnvironment() {
        return this.children.stream().map(Configuration::verifyEnvironment).findFirst().get();
    }

    private static List<Configuration> pickChildren(List<Configuration> configs) {
        List<Configuration> working = configs.stream().filter(c -> !c.verifyEnvironment().isPresent()).sorted(PrioritisingTestConfiguration.byPriority()).collect(Collectors.toList());
        if (working.isEmpty()) {
            return configs;
        }
        return working;
    }

    private static Comparator<Configuration> byPriority() {
        return Comparator.comparingInt(Configuration::priority);
    }

    private TestUnitFinder makeFinder(List<Configuration> children) {
        List<TestUnitFinder> finders = children.stream().map(Configuration::testUnitFinder).collect(Collectors.toList());
        return new PrioritisingTestUnitFinder(finders);
    }

    private TestSuiteFinder makeSuiteFinder(List<Configuration> children) {
        List<TestSuiteFinder> finders = children.stream().map(Configuration::testSuiteFinder).collect(Collectors.toList());
        return new PrioritisingTestSuiteFinder(finders);
    }
}

