/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine;

import java.io.Serializable;
import java.util.Objects;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.MethodName;

public final class Location
implements Comparable<Location>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ClassName clazz;
    private final MethodName method;
    private final String methodDesc;

    public Location(ClassName clazz, MethodName method, String methodDesc) {
        this.clazz = clazz;
        this.method = method;
        this.methodDesc = methodDesc;
    }

    public static Location location(ClassName clazz, MethodName method, String methodDesc) {
        return new Location(clazz, method, methodDesc);
    }

    public ClassName getClassName() {
        return this.clazz;
    }

    public MethodName getMethodName() {
        return this.method;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.method, this.methodDesc);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.method, other.method) && Objects.equals(this.methodDesc, other.methodDesc);
    }

    public String toString() {
        return "Location [clazz=" + this.clazz + ", method=" + this.method + ", methodDesc=" + this.methodDesc + "]";
    }

    public String describe() {
        return this.method.name();
    }

    @Override
    public int compareTo(Location o) {
        int comp = this.clazz.compareTo(o.getClassName());
        if (comp != 0) {
            return comp;
        }
        comp = this.method.name().compareTo(o.getMethodName().name());
        if (comp != 0) {
            return comp;
        }
        return this.methodDesc.compareTo(o.getMethodDesc());
    }
}

