/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

public class AvoidAssertsMethodAdapter
extends MethodVisitor {
    private static final String DISABLE_REASON = "ASSERTS";
    private final MutationContext context;
    private boolean assertBlockStarted;
    private Label destination;

    public AvoidAssertsMethodAdapter(MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(589824, delegateMethodVisitor);
        this.context = context;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 182 && "java/lang/Class".equals(owner) && "desiredAssertionStatus".equals(name)) {
            this.context.disableMutations(DISABLE_REASON);
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if ("$assertionsDisabled".equals(name)) {
            if (opcode == 178) {
                this.context.disableMutations(DISABLE_REASON);
                this.assertBlockStarted = true;
            } else if (opcode == 179) {
                this.context.enableMutatations(DISABLE_REASON);
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitJumpInsn(int opcode, Label destination) {
        if (opcode == 154 && this.assertBlockStarted) {
            this.destination = destination;
            this.assertBlockStarted = false;
        }
        super.visitJumpInsn(opcode, destination);
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (this.destination == label) {
            this.context.enableMutatations(DISABLE_REASON);
            this.destination = null;
        }
    }
}

