/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import java.util.Collections;
import java.util.Map;
import org.pitest.mutationtest.engine.gregor.AbstractInsnMutator;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.ZeroOperandMutation;
import org.pitest.reloc.asm.AnnotationVisitor;
import org.pitest.reloc.asm.MethodVisitor;

class NullReturnMethodVisitor
extends AbstractInsnMutator {
    private boolean hasNotNullAnnotation;

    NullReturnMethodVisitor(MethodMutatorFactory factory, MethodInfo methodInfo, MutationContext context, MethodVisitor writer) {
        super(factory, methodInfo, context, writer);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.hasNotNullAnnotation |= desc.endsWith("NotNull;");
        return super.visitAnnotation(desc, visible);
    }

    @Override
    protected boolean canMutate(int opcode) {
        return super.canMutate(opcode) && !this.hasNotNullAnnotation;
    }

    @Override
    protected Map<Integer, ZeroOperandMutation> getMutations() {
        return Collections.singletonMap(176, NullReturnMethodVisitor.nullReturn());
    }

    private static ZeroOperandMutation nullReturn() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opCode, MethodVisitor mv) {
                mv.visitInsn(87);
                mv.visitInsn(1);
                mv.visitInsn(176);
            }

            @Override
            public String describe(int opCode, MethodInfo methodInfo) {
                return "replaced return value with null for " + methodInfo.getDescription();
            }
        };
    }
}

