/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.util.ArrayList;
import java.util.List;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.testapi.Description;
import org.pitest.testapi.TestListener;
import org.pitest.testapi.TestResult;

public class CheckTestHasFailedResultListener
implements TestListener {
    private final List<Description> succeedingTests = new ArrayList<Description>();
    private final List<Description> failingTests = new ArrayList<Description>();
    private final boolean recordPassingTests;
    private int testsRun = 0;

    public CheckTestHasFailedResultListener(boolean recordPassingTests) {
        this.recordPassingTests = recordPassingTests;
    }

    @Override
    public void onTestFailure(TestResult tr) {
        this.failingTests.add(tr.getDescription());
    }

    @Override
    public void onTestSkipped(TestResult tr) {
    }

    @Override
    public void onTestStart(Description d) {
        ++this.testsRun;
    }

    @Override
    public void onTestSuccess(TestResult tr) {
        if (this.recordPassingTests) {
            this.succeedingTests.add(tr.getDescription());
        }
    }

    public DetectionStatus status() {
        if (!this.failingTests.isEmpty()) {
            return DetectionStatus.KILLED;
        }
        return DetectionStatus.SURVIVED;
    }

    public List<Description> getSucceedingTests() {
        return this.succeedingTests;
    }

    public List<Description> getFailingTests() {
        return this.failingTests;
    }

    public int getNumberOfTestsRun() {
        return this.testsRun;
    }

    @Override
    public void onRunEnd() {
    }

    @Override
    public void onRunStart() {
    }
}

