/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.net.ServerSocket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.execute.MinionArguments;
import org.pitest.util.CommunicationThread;
import org.pitest.util.Log;
import org.pitest.util.ReceiveStrategy;
import org.pitest.util.SafeDataInputStream;
import org.pitest.util.SafeDataOutputStream;

public class MutationTestCommunicationThread
extends CommunicationThread {
    private static final Logger LOG = Log.getLogger();
    private final Map<MutationIdentifier, MutationStatusTestPair> idMap;

    public MutationTestCommunicationThread(ServerSocket socket, MinionArguments arguments, Map<MutationIdentifier, MutationStatusTestPair> idMap) {
        super(socket, new SendData(arguments), new Receive(idMap));
        this.idMap = idMap;
    }

    public MutationStatusTestPair getStatus(MutationIdentifier id) {
        return this.idMap.get(id);
    }

    private static class Receive
    implements ReceiveStrategy {
        private final Map<MutationIdentifier, MutationStatusTestPair> idMap;

        Receive(Map<MutationIdentifier, MutationStatusTestPair> idMap) {
            this.idMap = idMap;
        }

        @Override
        public void apply(byte control, SafeDataInputStream is) {
            switch (control) {
                case 1: {
                    this.handleDescribe(is);
                    break;
                }
                case 2: {
                    this.handleReport(is);
                }
            }
        }

        private void handleReport(SafeDataInputStream is) {
            MutationIdentifier mutation = is.read(MutationIdentifier.class);
            MutationStatusTestPair value = is.read(MutationStatusTestPair.class);
            this.idMap.put(mutation, value);
            LOG.fine(mutation + " " + value);
        }

        private void handleDescribe(SafeDataInputStream is) {
            MutationIdentifier mutation = is.read(MutationIdentifier.class);
            this.idMap.put(mutation, MutationStatusTestPair.notAnalysed(1, DetectionStatus.STARTED));
        }
    }

    private static class SendData
    implements Consumer<SafeDataOutputStream> {
        private final MinionArguments arguments;

        SendData(MinionArguments arguments) {
            this.arguments = arguments;
        }

        @Override
        public void accept(SafeDataOutputStream dos) {
            dos.write(this.arguments);
            dos.flush();
        }
    }
}

