/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.lang.management.MemoryNotificationInfo;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.pitest.boot.HotSwapAgent;
import org.pitest.classinfo.CachingByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.config.ClientPluginServices;
import org.pitest.mutationtest.config.MinionSettings;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.execute.CommandLineMessage;
import org.pitest.mutationtest.execute.DefaultReporter;
import org.pitest.mutationtest.execute.HotSwap;
import org.pitest.mutationtest.execute.MemoryWatchdog;
import org.pitest.mutationtest.execute.MinionArguments;
import org.pitest.mutationtest.execute.MutationTestWorker;
import org.pitest.mutationtest.execute.Reporter;
import org.pitest.mutationtest.execute.TimeOutDecoratedTestSource;
import org.pitest.mutationtest.mocksupport.BendJavassistToMyWillTransformer;
import org.pitest.mutationtest.mocksupport.JavassistInputStreamInterceptorAdapater;
import org.pitest.mutationtest.mocksupport.JavassistInterceptor;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.execute.FindTestUnits;
import org.pitest.util.ExitCode;
import org.pitest.util.Glob;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.SafeDataInputStream;

public class MutationTestMinion {
    private static final Logger LOG = Log.getLogger();
    private static final int CACHE_SIZE = 12;
    private final SafeDataInputStream dis;
    private final Reporter reporter;
    private final MinionSettings plugins;

    public MutationTestMinion(MinionSettings plugins, SafeDataInputStream dis, Reporter reporter) {
        this.dis = dis;
        this.reporter = reporter;
        this.plugins = plugins;
    }

    public void run() {
        try {
            MinionArguments paramsFromParent = this.dis.read(MinionArguments.class);
            Log.setVerbose(paramsFromParent.isVerbose());
            ClassLoader loader = IsolationUtils.getContextClassLoader();
            CachingByteArraySource byteSource = new CachingByteArraySource(new ClassloaderByteArraySource(loader), 12);
            HotSwap hotswap = new HotSwap(byteSource);
            MutationEngine engine = this.createEngine(paramsFromParent.engine, paramsFromParent.engineArgs);
            MutationTestWorker worker = new MutationTestWorker(hotswap, engine.createMutator(byteSource), loader, paramsFromParent.fullMutationMatrix);
            List<TestUnit> tests = MutationTestMinion.findTestsForTestClasses(loader, paramsFromParent.testClasses, this.createTestPlugin(paramsFromParent.pitConfig));
            worker.run(paramsFromParent.mutations, this.reporter, new TimeOutDecoratedTestSource(paramsFromParent.timeoutStrategy, tests, this.reporter));
            this.reporter.done(ExitCode.OK);
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.out);
            LOG.log(Level.WARNING, "Error during mutation test", ex);
            this.reporter.done(ExitCode.UNKNOWN_ERROR);
        }
    }

    private MutationEngine createEngine(String engine, EngineArguments args) {
        return this.plugins.createEngine(engine).createEngine(args);
    }

    private Configuration createTestPlugin(TestPluginArguments pitConfig) {
        return this.plugins.getTestFrameworkPlugin(pitConfig, ClassloaderByteArraySource.fromContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        LOG.log(Level.FINE, "minion started");
        MutationTestMinion.enablePowerMockSupport();
        int port = Integer.parseInt(args[0]);
        Socket s = null;
        try {
            s = new Socket("localhost", port);
            SafeDataInputStream dis = new SafeDataInputStream(s.getInputStream());
            DefaultReporter reporter = new DefaultReporter(s.getOutputStream());
            MutationTestMinion.addMemoryWatchDog(reporter);
            ClientPluginServices plugins = new ClientPluginServices(IsolationUtils.getContextClassLoader());
            MinionSettings factory = new MinionSettings(plugins);
            MutationTestMinion instance = new MutationTestMinion(factory, dis, reporter);
            instance.run();
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.out);
            LOG.log(Level.WARNING, "Error during mutation test", ex);
        }
        finally {
            if (s != null) {
                MutationTestMinion.safelyCloseSocket(s);
            }
        }
    }

    private static List<TestUnit> findTestsForTestClasses(ClassLoader loader, Collection<ClassName> testClasses, Configuration pitConfig) {
        Collection tcs = testClasses.stream().flatMap(ClassName.nameToClass(loader)).collect(Collectors.toList());
        FindTestUnits finder = new FindTestUnits(pitConfig);
        return finder.findTestUnitsForAllSuppliedClasses(tcs);
    }

    private static void enablePowerMockSupport() {
        HotSwapAgent.addTransformer(new BendJavassistToMyWillTransformer(Prelude.or(new Glob("javassist/*")), JavassistInputStreamInterceptorAdapater.inputStreamAdapterSupplier(JavassistInterceptor.class)));
    }

    private static void safelyCloseSocket(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Couldn't close socket", e);
            }
        }
    }

    private static void addMemoryWatchDog(Reporter r) {
        NotificationListener listener = (notification, handback) -> {
            String type = notification.getType();
            if (type.equals("java.management.memory.threshold.exceeded")) {
                CompositeData cd = (CompositeData)notification.getUserData();
                MemoryNotificationInfo memInfo = MemoryNotificationInfo.from(cd);
                CommandLineMessage.report(memInfo.getPoolName() + " has exceeded the shutdown threshold : " + memInfo.getCount() + " times.\n" + memInfo.getUsage());
                r.done(ExitCode.OUT_OF_MEMORY);
            } else {
                LOG.warning("Unknown notification: " + notification);
            }
        };
        MemoryWatchdog.addWatchDogToAllPools(90L, listener);
    }
}

