/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationAnalyser;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.incremental.CodeHistory;
import org.pitest.util.Log;

public class IncrementalAnalyser
implements MutationAnalyser {
    private static final Logger LOG = Log.getLogger();
    private final CodeHistory history;
    private final CoverageDatabase coverage;
    private final Map<DetectionStatus, Long> preAnalysed = new EnumMap<DetectionStatus, Long>(DetectionStatus.class);

    public IncrementalAnalyser(CodeHistory history, CoverageDatabase coverage) {
        this.history = history;
        this.coverage = coverage;
    }

    @Override
    public Collection<MutationResult> analyse(Collection<MutationDetails> mutation) {
        ArrayList<MutationResult> mrs = new ArrayList<MutationResult>(mutation.size());
        for (MutationDetails each : mutation) {
            Optional<MutationStatusTestPair> maybeResult = this.history.getPreviousResult(each.getId());
            if (!maybeResult.isPresent()) {
                mrs.add(this.analyseFromScratch(each));
                continue;
            }
            mrs.add(this.analyseFromHistory(each, maybeResult.get()));
        }
        this.logTotals();
        return mrs;
    }

    private void logTotals() {
        int numberOfReducedMutations = 0;
        for (Map.Entry<DetectionStatus, Long> each : this.preAnalysed.entrySet()) {
            Long numberOfMutationsInStatus = each.getValue();
            DetectionStatus mutationStatus = each.getKey();
            LOG.fine("Incremental analysis set " + numberOfMutationsInStatus + " mutations to a status of " + (Object)((Object)mutationStatus));
            if (mutationStatus == DetectionStatus.NOT_STARTED) continue;
            numberOfReducedMutations = (int)((long)numberOfReducedMutations + numberOfMutationsInStatus);
        }
        LOG.info("Incremental analysis reduced number of mutations by " + numberOfReducedMutations);
    }

    private MutationResult analyseFromHistory(MutationDetails each, MutationStatusTestPair mutationStatusTestPair) {
        List<String> killingTestNames;
        ClassName clazz = each.getClassName();
        if (this.history.hasClassChanged(clazz)) {
            return this.analyseFromScratch(each);
        }
        if (mutationStatusTestPair.getStatus() == DetectionStatus.TIMED_OUT) {
            return this.makeResult(each, DetectionStatus.TIMED_OUT);
        }
        if (mutationStatusTestPair.getStatus() == DetectionStatus.KILLED && !(killingTestNames = this.filterUnchangedKillingTests(each, mutationStatusTestPair)).isEmpty()) {
            return this.makeResult(each, DetectionStatus.KILLED, killingTestNames, mutationStatusTestPair.getSucceedingTests());
        }
        if (mutationStatusTestPair.getStatus() == DetectionStatus.SURVIVED && !this.history.hasCoverageChanged(clazz, this.coverage.getCoverageIdForClass(clazz))) {
            return this.makeResult(each, DetectionStatus.SURVIVED);
        }
        return this.analyseFromScratch(each);
    }

    private List<String> filterUnchangedKillingTests(MutationDetails each, MutationStatusTestPair mutationStatusTestPair) {
        return this.coverage.getTestsForClass(each.getClassName()).stream().filter(IncrementalAnalyser.isAKillingTestFor(mutationStatusTestPair)).filter(this.testClassDidNotChange()).map(TestInfo::getName).collect(Collectors.toList());
    }

    private Predicate<TestInfo> testClassDidNotChange() {
        return a -> !this.history.hasClassChanged(TestInfo.toDefiningClassName().apply((TestInfo)a));
    }

    private static Predicate<TestInfo> isAKillingTestFor(MutationStatusTestPair mutation) {
        List<String> killingTestNames = mutation.getKillingTests();
        return a -> killingTestNames.contains(a.getName());
    }

    private MutationResult analyseFromScratch(MutationDetails mutation) {
        return this.makeResult(mutation, DetectionStatus.NOT_STARTED);
    }

    private MutationResult makeResult(MutationDetails each, DetectionStatus status) {
        return this.makeResult(each, status, Collections.emptyList(), Collections.emptyList());
    }

    private MutationResult makeResult(MutationDetails each, DetectionStatus status, List<String> killingTests, List<String> succeedingTests) {
        this.updatePreanalysedTotal(status);
        return new MutationResult(each, new MutationStatusTestPair(0, status, killingTests, succeedingTests));
    }

    private void updatePreanalysedTotal(DetectionStatus status) {
        this.preAnalysed.merge(status, 1L, Long::sum);
    }
}

