/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.mocksupport;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.bytecode.FrameOptions;
import org.pitest.classinfo.ComputeClassWriter;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.ClassWriter;

public class BendJavassistToMyWillTransformer
implements ClassFileTransformer {
    private final Predicate<String> filter;
    private final Function<ClassWriter, ClassVisitor> transformation;
    private final Map<String, String> computeCache = new ConcurrentHashMap<String, String>();

    public BendJavassistToMyWillTransformer(Predicate<String> filter, Function<ClassWriter, ClassVisitor> transformation) {
        this.filter = filter;
        this.transformation = transformation;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (this.shouldInclude(className)) {
            ClassReader reader = new ClassReader(classfileBuffer);
            ComputeClassWriter writer = new ComputeClassWriter(new ClassloaderByteArraySource(loader), this.computeCache, FrameOptions.pickFlags(classfileBuffer));
            reader.accept(this.transformation.apply(writer), 8);
            return writer.toByteArray();
        }
        return null;
    }

    private boolean shouldInclude(String className) {
        return this.filter.test(className);
    }
}

