/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.functional.FCollection;
import org.pitest.plugin.FeatureSetting;
import org.pitest.plugin.ProvidesFeature;

public class FeatureSelector<T extends ProvidesFeature> {
    private final Map<String, Collection<FeatureSetting>> settings;
    private final List<T> active;

    public FeatureSelector(List<FeatureSetting> features, Collection<T> filters) {
        this.settings = FCollection.bucket(features, this.byFeature());
        this.active = this.selectFeatures(features, filters);
    }

    public List<T> getActiveFeatures() {
        return this.active;
    }

    public FeatureSetting getSettingForFeature(String feature) {
        FeatureSetting conf = null;
        Collection<FeatureSetting> groupedSettings = this.settings.get(feature.toLowerCase());
        if (groupedSettings != null) {
            conf = groupedSettings.iterator().next();
        }
        return conf;
    }

    private List<T> selectFeatures(List<FeatureSetting> features, Collection<T> filters) {
        ArrayList<T> factories = new ArrayList<T>(filters);
        Map<String, Collection<T>> featureMap = FCollection.bucket(factories, this.byFeatureName());
        List<T> active = FCollection.filter(factories, this.isOnByDefault());
        for (FeatureSetting each : features) {
            Collection<T> providers = featureMap.get(each.feature().toLowerCase());
            if (providers == null || providers.isEmpty()) continue;
            if (each.addsFeature()) {
                active.addAll(providers);
            }
            if (!each.removesFeature()) continue;
            active.removeAll(providers);
        }
        return active;
    }

    private Predicate<T> isOnByDefault() {
        return a -> a.provides().isOnByDefault();
    }

    private Function<T, String> byFeatureName() {
        return a -> a.provides().name().toLowerCase();
    }

    private Function<FeatureSetting, String> byFeature() {
        return a -> a.feature().toLowerCase();
    }
}

