/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testapi;

import java.util.Objects;
import org.pitest.testapi.Description;
import org.pitest.testapi.TestUnitState;

public final class TestResult {
    private final Description description;
    private final Throwable throwable;
    private final TestUnitState state;

    public TestResult(Description description, Throwable t) {
        this(description, t, TestUnitState.FINISHED);
    }

    public TestResult(Description description, Throwable t, TestUnitState state) {
        this.description = description;
        this.throwable = t;
        this.state = state;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public TestUnitState getState() {
        return this.state;
    }

    public Description getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.throwable, this.state});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TestResult other = (TestResult)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.throwable, other.throwable) && this.state == other.state;
    }

    public String toString() {
        return "TestResult [description=" + this.description + ", state=" + (Object)((Object)this.state) + ", throwable=" + this.throwable + "]";
    }
}

